/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.theoneprobe;

import javax.annotation.Nonnull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.math.MathUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.integration.theoneprobe.TOPElement;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public abstract class ChemicalElement<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends TOPElement {
    @Nonnull
    protected final STACK stored;
    protected final long capacity;

    protected ChemicalElement(@Nonnull STACK stored, long capacity) {
        super(-16777216, 0xFFFFFF);
        this.stored = stored;
        this.capacity = capacity;
    }

    public void toBytes(PacketBuffer buf) {
        ChemicalUtils.writeChemicalStack(buf, this.stored);
        buf.func_179254_b(this.capacity);
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0L || ((ChemicalStack)this.stored).getAmount() == Long.MAX_VALUE) {
            return level;
        }
        return MathUtils.clampToInt((double)level * (double)((ChemicalStack)this.stored).getAmount() / (double)this.capacity);
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return ((ChemicalStack)this.stored).isEmpty() ? null : MekanismRenderer.getChemicalTexture(((ChemicalStack)this.stored).getType());
    }

    protected abstract ILangEntry getStoredFormat();

    @Override
    public ITextComponent getText() {
        long amount = ((ChemicalStack)this.stored).getAmount();
        if (amount == Long.MAX_VALUE) {
            return MekanismLang.GENERIC_STORED.translate(((ChemicalStack)this.stored).getType(), MekanismLang.INFINITE);
        }
        return this.getStoredFormat().translate(((ChemicalStack)this.stored).getType(), amount);
    }

    @Override
    protected boolean applyRenderColor() {
        MekanismRenderer.color(((ChemicalStack)this.stored).getType());
        return true;
    }
}

