/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.IChemicalHandlerWrapper;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasHandlerWrapper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.slot.ChemicalInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GasInventorySlot
extends ChemicalInventorySlot<Gas, GasStack> {
    @Nullable
    public static IChemicalHandlerWrapper<Gas, GasStack> getCapabilityWrapper(ItemStack stack) {
        Optional capability;
        if (!stack.func_190926_b() && (capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY))).isPresent()) {
            return new GasHandlerWrapper((IGasHandler)capability.get());
        }
        return null;
    }

    private static GasStack getPotentialConversion(@Nullable World world, ItemStack itemStack) {
        ItemStackToGasRecipe foundRecipe = MekanismRecipeType.GAS_CONVERSION.findFirst(world, recipe -> recipe.getInput().testType(itemStack));
        return foundRecipe == null ? GasStack.EMPTY : foundRecipe.getOutput(itemStack);
    }

    public static GasInventorySlot rotaryDrain(IGasTank gasTank, BooleanSupplier modeSupplier, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null");
        Predicate<@NonNull ItemStack> insertPredicate = GasInventorySlot.getDrainInsertPredicate(gasTank, GasInventorySlot::getCapabilityWrapper).and(stack -> modeSupplier.getAsBoolean());
        return new GasInventorySlot(gasTank, insertPredicate.negate(), insertPredicate, stack -> stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent(), inventory, x, y);
    }

    public static GasInventorySlot rotaryFill(IGasTank gasTank, BooleanSupplier modeSupplier, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null");
        return new GasInventorySlot(gasTank, GasInventorySlot.getFillExtractPredicate(gasTank, GasInventorySlot::getCapabilityWrapper), stack -> !modeSupplier.getAsBoolean() && GasInventorySlot.fillInsertCheck(gasTank, GasInventorySlot.getCapabilityWrapper(stack)), stack -> stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent(), inventory, x, y);
    }

    public static GasInventorySlot fillOrConvert(IGasTank gasTank, Supplier<World> worldSupplier, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        Function<ItemStack, GasStack> potentialConversionSupplier = stack -> GasInventorySlot.getPotentialConversion((World)worldSupplier.get(), stack);
        return new GasInventorySlot(gasTank, worldSupplier, GasInventorySlot.getFillOrConvertExtractPredicate(gasTank, GasInventorySlot::getCapabilityWrapper, potentialConversionSupplier), GasInventorySlot.getFillOrConvertInsertPredicate(gasTank, GasInventorySlot::getCapabilityWrapper, potentialConversionSupplier), stack -> {
            if (stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent()) {
                return true;
            }
            GasStack gasConversion = GasInventorySlot.getPotentialConversion((World)worldSupplier.get(), stack);
            return !gasConversion.isEmpty() && gasTank.isValid(gasConversion);
        }, inventory, x, y);
    }

    public static GasInventorySlot fill(IGasTank gasTank, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        return new GasInventorySlot(gasTank, GasInventorySlot.getFillExtractPredicate(gasTank, GasInventorySlot::getCapabilityWrapper), stack -> GasInventorySlot.fillInsertCheck(gasTank, GasInventorySlot.getCapabilityWrapper(stack)), stack -> stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent(), inventory, x, y);
    }

    public static GasInventorySlot drain(IGasTank gasTank, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Predicate<@NonNull ItemStack> insertPredicate = GasInventorySlot.getDrainInsertPredicate(gasTank, GasInventorySlot::getCapabilityWrapper);
        return new GasInventorySlot(gasTank, insertPredicate.negate(), insertPredicate, stack -> stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent(), inventory, x, y);
    }

    private GasInventorySlot(IGasTank gasTank, Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IMekanismInventory inventory, int x, int y) {
        this(gasTank, () -> null, canExtract, canInsert, validator, inventory, x, y);
    }

    private GasInventorySlot(IGasTank gasTank, Supplier<World> worldSupplier, Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IMekanismInventory inventory, int x, int y) {
        super(gasTank, worldSupplier, canExtract, canInsert, validator, inventory, x, y);
    }

    @Override
    @Nullable
    protected IChemicalHandlerWrapper<Gas, GasStack> getCapabilityWrapper() {
        return GasInventorySlot.getCapabilityWrapper(this.current);
    }

    @Override
    @Nullable
    protected Pair<ItemStack, GasStack> getConversion() {
        ItemStack itemInput;
        ItemStackToGasRecipe foundRecipe = MekanismRecipeType.GAS_CONVERSION.findFirst((World)this.worldSupplier.get(), recipe -> recipe.getInput().test(this.current));
        if (foundRecipe != null && !(itemInput = foundRecipe.getInput().getMatchingInstance(this.current)).func_190926_b()) {
            return Pair.of((Object)itemInput, (Object)foundRecipe.getOutput(itemInput));
        }
        return null;
    }
}

