/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IIncrementalEnum;
import mekanism.api.IMekWrench;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.IItemHUDProvider;
import mekanism.common.item.IModeItem;
import mekanism.common.item.ItemEnergized;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemConfigurator
extends ItemEnergized
implements IMekWrench,
IModeItem,
IItemHUDProvider {
    public ItemConfigurator(Item.Properties properties) {
        super(MekanismConfig.gear.configuratorChargeRate, MekanismConfig.gear.configuratorMaxEnergy, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(MekanismLang.STATE.translateColored(EnumColor.PINK, this.getState(stack)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (world.field_72995_K || player == null) return ActionResultType.PASS;
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        Hand hand = context.func_221531_n();
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, pos);
        if (this.getState(stack).isConfigurating()) {
            TransmissionType transmissionType = Objects.requireNonNull(this.getState(stack).getTransmission(), "Configurating state requires transmission type");
            if (tile instanceof ISideConfiguration && ((ISideConfiguration)tile).getConfig().supports(transmissionType)) {
                ISideConfiguration config = (ISideConfiguration)tile;
                ConfigInfo info = config.getConfig().getConfig(transmissionType);
                if (info == null) return ActionResultType.SUCCESS;
                RelativeSide relativeSide = RelativeSide.fromDirections(config.getOrientation(), side);
                DataType dataType = info.getDataType(relativeSide);
                if (!player.func_225608_bj_()) {
                    player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.CONFIGURATOR_VIEW_MODE.translateColored(EnumColor.GRAY, new Object[]{transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName()})));
                    return ActionResultType.SUCCESS;
                } else if (SecurityUtils.canAccess(player, tile)) {
                    if (!player.func_184812_l_()) {
                        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                        FloatingLong energyPerConfigure = (FloatingLong)MekanismConfig.gear.configuratorEnergyPerConfigure.get();
                        if (energyContainer == null || energyContainer.extract(energyPerConfigure, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerConfigure)) {
                            return ActionResultType.FAIL;
                        }
                        energyContainer.extract(energyPerConfigure, Action.EXECUTE, AutomationType.MANUAL);
                    }
                    dataType = info.incrementDataType(relativeSide);
                    player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.CONFIGURATOR_TOGGLE_MODE.translateColored(EnumColor.GRAY, new Object[]{transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName()})));
                    config.getConfig().sideChanged(transmissionType, relativeSide);
                    return ActionResultType.SUCCESS;
                } else {
                    SecurityUtils.displayNoAccess(player);
                }
                return ActionResultType.SUCCESS;
            }
            if (SecurityUtils.canAccess(player, tile)) {
                Optional<IConfigurable> capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.CONFIGURABLE_CAPABILITY, side));
                if (!capability.isPresent()) return ActionResultType.PASS;
                IConfigurable config = capability.get();
                if (!player.func_225608_bj_()) return config.onRightClick(player, side);
                return config.onSneakRightClick(player, side);
            }
            SecurityUtils.displayNoAccess(player);
            return ActionResultType.SUCCESS;
        }
        if (this.getState(stack) == ConfiguratorMode.EMPTY) {
            IMekanismInventory inv;
            if (!(tile instanceof IMekanismInventory) || !(inv = (IMekanismInventory)tile).hasInventory()) return ActionResultType.PASS;
            if (SecurityUtils.canAccess(player, tile)) {
                IEnergyContainer energyContainer;
                boolean creative = player.func_184812_l_();
                IEnergyContainer iEnergyContainer = energyContainer = creative ? null : StorageUtils.getEnergyContainer(stack, 0);
                if (!creative && energyContainer == null) {
                    return ActionResultType.FAIL;
                }
                FloatingLong energyPerItemDump = (FloatingLong)MekanismConfig.gear.configuratorEnergyPerItem.get();
                for (IInventorySlot inventorySlot : inv.getInventorySlots(null)) {
                    if (inventorySlot.isEmpty()) continue;
                    if (!creative) {
                        if (energyContainer.extract(energyPerItemDump, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerItemDump)) return ActionResultType.SUCCESS;
                        energyContainer.extract(energyPerItemDump, Action.EXECUTE, AutomationType.MANUAL);
                    }
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)inventorySlot.getStack().func_77946_l());
                    inventorySlot.setStack(ItemStack.field_190927_a);
                }
                return ActionResultType.SUCCESS;
            }
            SecurityUtils.displayNoAccess(player);
            return ActionResultType.FAIL;
        }
        if (this.getState(stack) == ConfiguratorMode.ROTATE) {
            if (!(tile instanceof TileEntityMekanism)) return ActionResultType.SUCCESS;
            if (SecurityUtils.canAccess(player, tile)) {
                TileEntityMekanism tileMekanism = (TileEntityMekanism)tile;
                if (!player.func_225608_bj_()) {
                    tileMekanism.setFacing(side);
                    return ActionResultType.SUCCESS;
                } else {
                    if (!player.func_225608_bj_()) return ActionResultType.SUCCESS;
                    tileMekanism.setFacing(side.func_176734_d());
                }
                return ActionResultType.SUCCESS;
            } else {
                SecurityUtils.displayNoAccess(player);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.getState(stack) != ConfiguratorMode.WRENCH) return ActionResultType.PASS;
        return ActionResultType.PASS;
    }

    public EnumColor getColor(ConfiguratorMode mode) {
        return mode.getColor();
    }

    public void setState(ItemStack stack, ConfiguratorMode state) {
        ItemDataUtils.setInt(stack, "state", state.ordinal());
    }

    public ConfiguratorMode getState(ItemStack stack) {
        return ConfiguratorMode.byIndexStatic(ItemDataUtils.getInt(stack, "state"));
    }

    @Override
    public boolean canUseWrench(ItemStack stack, PlayerEntity player, BlockPos pos) {
        return this.getState(stack) == ConfiguratorMode.WRENCH;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return this.getState(stack) == ConfiguratorMode.WRENCH;
    }

    @Override
    public void addHUDStrings(List<ITextComponent> list, ItemStack stack, EquipmentSlotType slotType) {
        list.add(MekanismLang.MODE.translateColored(EnumColor.PINK, this.getState(stack)));
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        ConfiguratorMode newMode;
        ConfiguratorMode mode = this.getState(stack);
        if (mode != (newMode = (ConfiguratorMode)mode.adjust(shift))) {
            this.setState(stack, newMode);
            if (displayChangeMessage) {
                player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.CONFIGURE_STATE.translateColored(EnumColor.GRAY, newMode)));
            }
        }
    }

    @Override
    @Nonnull
    public ITextComponent getScrollTextComponent(@Nonnull ItemStack stack) {
        return this.getState(stack).getTextComponent();
    }

    @FieldsAreNonnullByDefault
    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static enum ConfiguratorMode implements IIncrementalEnum<ConfiguratorMode>,
    IHasTextComponent
    {
        CONFIGURATE_ITEMS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ITEM, EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_FLUIDS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.FLUID, EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_GASES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.GAS, EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_ENERGY(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ENERGY, EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_HEAT(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.HEAT, EnumColor.BRIGHT_GREEN, true),
        EMPTY(MekanismLang.CONFIGURATOR_EMPTY, null, EnumColor.DARK_RED, false),
        ROTATE(MekanismLang.CONFIGURATOR_ROTATE, null, EnumColor.YELLOW, false),
        WRENCH(MekanismLang.CONFIGURATOR_WRENCH, null, EnumColor.PINK, false);

        private static final ConfiguratorMode[] MODES;
        private final ILangEntry langEntry;
        @Nullable
        private final TransmissionType transmissionType;
        private final EnumColor color;
        private final boolean configurating;

        private ConfiguratorMode(ILangEntry langEntry, TransmissionType transmissionType, EnumColor color, boolean configurating) {
            this.langEntry = langEntry;
            this.transmissionType = transmissionType;
            this.color = color;
            this.configurating = configurating;
        }

        @Override
        public ITextComponent getTextComponent() {
            if (this.transmissionType != null) {
                return this.langEntry.translateColored(this.color, this.transmissionType);
            }
            return this.langEntry.translateColored(this.color, new Object[0]);
        }

        public EnumColor getColor() {
            return this.color;
        }

        public boolean isConfigurating() {
            return this.configurating;
        }

        @Nullable
        public TransmissionType getTransmission() {
            switch (this) {
                case CONFIGURATE_ITEMS: {
                    return TransmissionType.ITEM;
                }
                case CONFIGURATE_FLUIDS: {
                    return TransmissionType.FLUID;
                }
                case CONFIGURATE_GASES: {
                    return TransmissionType.GAS;
                }
                case CONFIGURATE_ENERGY: {
                    return TransmissionType.ENERGY;
                }
                case CONFIGURATE_HEAT: {
                    return TransmissionType.HEAT;
                }
            }
            return null;
        }

        @Override
        @Nonnull
        public ConfiguratorMode byIndex(int index) {
            return ConfiguratorMode.byIndexStatic(index);
        }

        public static ConfiguratorMode byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = ConfiguratorMode.values();
        }
    }
}

