/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.fluid.IExtendedFluidHandler;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.GaugeDropperContentsHandler;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemGaugeDropper
extends Item {
    public ItemGaugeDropper(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        GasStack gasStack = StorageUtils.getStoredGasFromNBT(stack);
        if (!gasStack.isEmpty()) {
            return gasStack.getChemicalTint();
        }
        InfusionStack infusionStack = StorageUtils.getStoredInfusionFromNBT(stack);
        if (!infusionStack.isEmpty()) {
            return infusionStack.getChemicalTint();
        }
        FluidStack fluidStack = StorageUtils.getStoredFluidFromNBT(stack);
        if (!fluidStack.isEmpty()) {
            return fluidStack.getFluid().getAttributes().getColor(fluidStack);
        }
        return 0;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_() && !world.field_72995_K) {
            IFluidHandlerItem fluidHandler;
            Optional fluidCapability;
            Optional infusionCapability;
            Optional gasCapability = MekanismUtils.toOptional(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY));
            if (gasCapability.isPresent()) {
                IGasHandler gasHandlerItem = (IGasHandler)gasCapability.get();
                for (int tank = 0; tank < gasHandlerItem.getGasTankCount(); ++tank) {
                    gasHandlerItem.setGasInTank(tank, GasStack.EMPTY);
                }
            }
            if ((infusionCapability = MekanismUtils.toOptional(stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY))).isPresent()) {
                IInfusionHandler infusionHandlerItem = (IInfusionHandler)infusionCapability.get();
                for (int tank = 0; tank < infusionHandlerItem.getInfusionTankCount(); ++tank) {
                    infusionHandlerItem.setInfusionInTank(tank, InfusionStack.EMPTY);
                }
            }
            if ((fluidCapability = MekanismUtils.toOptional(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY))).isPresent() && (fluidHandler = (IFluidHandlerItem)fluidCapability.get()) instanceof IExtendedFluidHandler) {
                IExtendedFluidHandler fluidHandlerItem = (IExtendedFluidHandler)fluidHandler;
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    fluidHandlerItem.setFluidInTank(tank, FluidStack.EMPTY);
                }
            }
            ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        GasStack gasStack = StorageUtils.getStoredGasFromNBT(stack);
        InfusionStack infusionStack = StorageUtils.getStoredInfusionFromNBT(stack);
        FluidStack fluidStack = StorageUtils.getStoredFluidFromNBT(stack);
        if (gasStack.isEmpty() && infusionStack.isEmpty() && fluidStack.isEmpty()) {
            tooltip.add((ITextComponent)MekanismLang.EMPTY.translate(new Object[0]));
        } else if (!gasStack.isEmpty()) {
            tooltip.add((ITextComponent)MekanismLang.STORED.translate(gasStack, gasStack.getAmount()));
        } else if (!infusionStack.isEmpty()) {
            tooltip.add((ITextComponent)MekanismLang.STORED.translate(infusionStack, infusionStack.getAmount()));
        } else if (!fluidStack.isEmpty()) {
            tooltip.add((ITextComponent)MekanismLang.STORED.translate(fluidStack, fluidStack.getAmount()));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, GaugeDropperContentsHandler.create());
    }
}

