/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.machine.prefab.BlockTile;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.RateLimitGasHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.item.IItemSustainedInventory;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.security.ISecurityItem;
import mekanism.common.tier.GasTankTier;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.GasUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemBlockGasTank
extends ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityGasTank, Machine<TileEntityGasTank>>>
implements IItemSustainedInventory,
ISecurityItem {
    public ItemBlockGasTank(BlockTile.BlockTileModel<TileEntityGasTank, Machine<TileEntityGasTank>> block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        GasTankTier tier = Attribute.getTier(this.func_179223_d(), GasTankTier.class);
        StorageUtils.addStoredGas(stack, tooltip, true, MekanismLang.EMPTY, stored -> {
            if (stored.isEmpty()) {
                return MekanismLang.EMPTY.translate(new Object[0]);
            }
            if (tier == GasTankTier.CREATIVE) {
                return MekanismLang.GENERIC_STORED.translateColored(EnumColor.ORANGE, new Object[]{stored, EnumColor.GRAY, MekanismLang.INFINITE});
            }
            return MekanismLang.GENERIC_STORED.translateColored(EnumColor.ORANGE, new Object[]{stored, EnumColor.GRAY, stored.getAmount()});
        });
        if (tier == GasTankTier.CREATIVE) {
            tooltip.add(MekanismLang.CAPACITY.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, MekanismLang.INFINITE}));
        } else {
            tooltip.add(MekanismLang.CAPACITY_MB.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, tier.getStorage()}));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addDetails(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        tooltip.add(OwnerDisplay.of((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.getOwnerUUID(stack)).getTextComponent());
        tooltip.add(MekanismLang.SECURITY.translateColored(EnumColor.GRAY, SecurityUtils.getSecurity(stack, Dist.CLIENT)));
        if (SecurityUtils.isOverridden(stack, Dist.CLIENT)) {
            tooltip.add(MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0]));
        }
        tooltip.add(MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, new Object[]{EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))}));
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        GasTankTier tier;
        super.func_150895_a(group, items);
        if (this.func_194125_a(group) && (tier = Attribute.getTier(this.func_179223_d(), GasTankTier.class)) == GasTankTier.CREATIVE && MekanismConfig.general.prefilledGasTanks.get()) {
            for (Gas type : MekanismAPI.GAS_REGISTRY.getValues()) {
                if (type.isHidden()) continue;
                items.add((Object)GasUtils.getFilledVariant(new ItemStack((IItemProvider)this), tier.getStorage(), type));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return GasUtils.hasGas(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        GasStack stored = StorageUtils.getStoredGasFromNBT(stack);
        return stored.isEmpty() ? 0 : stored.getChemicalTint();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, RateLimitGasHandler.create(Attribute.getTier(this.func_179223_d(), GasTankTier.class)));
    }
}

