/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multiblock;

import java.util.Collection;
import mekanism.api.Coord4D;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;

public interface IValveHandler {
    default public void writeValves(CompoundNBT updateTag) {
        ListNBT valves = new ListNBT();
        for (ValveData valveData : this.getValveData()) {
            if (valveData.activeTicks <= 0) continue;
            CompoundNBT valveNBT = new CompoundNBT();
            valveData.location.write(valveNBT);
            valveNBT.func_74768_a("side", valveData.side.ordinal());
            valves.add((Object)valveNBT);
        }
        updateTag.func_218657_a("valve", (INBT)valves);
    }

    default public void readValves(CompoundNBT updateTag) {
        this.getValveData().clear();
        if (updateTag.func_150297_b("valve", 9)) {
            ListNBT valves = updateTag.func_150295_c("valve", 10);
            for (int i = 0; i < valves.size(); ++i) {
                CompoundNBT valveNBT = valves.func_150305_b(i);
                ValveData data = new ValveData();
                data.location = Coord4D.read(valveNBT);
                data.side = Direction.func_82600_a((int)valveNBT.func_74762_e("side"));
                this.getValveData().add(data);
            }
        }
    }

    default public boolean needsValveUpdate() {
        for (ValveData data : this.getValveData()) {
            if (data.activeTicks > 0) {
                --data.activeTicks;
            }
            if (data.activeTicks > 0 != data.prevActive) {
                return true;
            }
            data.prevActive = data.activeTicks > 0;
        }
        return false;
    }

    public Collection<ValveData> getValveData();

    public static class ValveData {
        public Direction side;
        public Coord4D location;
        public boolean prevActive;
        public int activeTicks;

        public void onTransfer() {
            this.activeTicks = 30;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.side.ordinal();
            code = 31 * code + this.location.hashCode();
            return code;
        }

        public boolean equals(Object obj) {
            return obj instanceof ValveData && ((ValveData)obj).side == this.side && ((ValveData)obj).location.equals(this.location);
        }
    }
}

