/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multiblock;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MultiblockManager<T extends SynchronizedData<T>> {
    private static Set<MultiblockManager<?>> managers = new ObjectOpenHashSet();
    public String name;
    public Map<UUID, MultiblockCache<T>> inventories = new Object2ObjectOpenHashMap();

    public MultiblockManager(String s) {
        this.name = s;
        managers.add(this);
    }

    public static void tick(World world) {
        for (MultiblockManager<?> manager : managers) {
            manager.tickSelf(world);
        }
    }

    @Nullable
    public static UUID getStructureId(TileEntityMultiblock<?> tile) {
        return tile.structure == null ? null : ((SynchronizedData)tile.getSynchronizedData()).inventoryID;
    }

    public static boolean areEqual(TileEntity tile1, TileEntity tile2) {
        if (tile1 instanceof TileEntityMultiblock && tile2 instanceof TileEntityMultiblock) {
            return ((TileEntityMultiblock)tile1).getManager() == ((TileEntityMultiblock)tile2).getManager();
        }
        return false;
    }

    public static void reset() {
        for (MultiblockManager<?> manager : managers) {
            manager.inventories.clear();
        }
    }

    public MultiblockCache<T> pullInventory(World world, UUID id) {
        MultiblockCache<T> toReturn = this.inventories.get(id);
        for (Coord4D obj : toReturn.locations) {
            TileEntityMultiblock tile = MekanismUtils.getTileEntity(TileEntityMultiblock.class, (IBlockReader)world, obj.getPos());
            if (tile == null) continue;
            tile.cachedData = tile.getNewCache();
            tile.cachedID = null;
        }
        this.inventories.remove(id);
        return toReturn;
    }

    public UUID getUniqueInventoryID() {
        return UUID.randomUUID();
    }

    public void tickSelf(World world) {
        ArrayList<UUID> idsToKill = new ArrayList<UUID>();
        Object2ObjectOpenHashMap tilesToKill = new Object2ObjectOpenHashMap();
        for (Map.Entry<UUID, MultiblockCache<T>> entry : this.inventories.entrySet()) {
            UUID inventoryID = entry.getKey();
            for (Coord4D obj : entry.getValue().locations) {
                TileEntity tile;
                if (!obj.dimension.equals(world.func_201675_m().func_186058_p()) || !world.func_195588_v(obj.getPos()) || (tile = MekanismUtils.getTileEntity((IBlockReader)world, obj.getPos())) instanceof TileEntityMultiblock && ((TileEntityMultiblock)tile).getManager() == this && (MultiblockManager.getStructureId((TileEntityMultiblock)tile) == null || Objects.equals(MultiblockManager.getStructureId((TileEntityMultiblock)tile), inventoryID))) continue;
                if (!tilesToKill.containsKey(inventoryID)) {
                    tilesToKill.put(inventoryID, new ObjectOpenHashSet());
                }
                ((Set)tilesToKill.get(inventoryID)).add(obj);
            }
            if (!entry.getValue().locations.isEmpty()) continue;
            idsToKill.add(inventoryID);
        }
        for (Map.Entry<UUID, MultiblockCache<Object>> entry : tilesToKill.entrySet()) {
            for (Coord4D obj : (Set)((Object)entry.getValue())) {
                this.inventories.get((Object)entry.getKey()).locations.remove(obj);
            }
        }
        for (UUID uUID : idsToKill) {
            this.inventories.remove(uUID);
        }
    }

    public void updateCache(TileEntityMultiblock<T> tile) {
        if (!this.inventories.containsKey(tile.cachedID)) {
            tile.cachedData.locations.add(Coord4D.get(tile));
            this.inventories.put(tile.cachedID, tile.cachedData);
        } else {
            this.inventories.get((Object)tile.cachedID).locations.add(Coord4D.get(tile));
        }
    }
}

