/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackGasToGasRecipe;
import mekanism.api.recipes.inputs.GasStackIngredient;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ItemStackGasToGasRecipeSerializer<T extends ItemStackGasToGasRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public ItemStackGasToGasRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @Nonnull
    public T read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray itemInput = JSONUtils.func_151202_d((JsonObject)json, (String)"itemInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"itemInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemIngredient = ItemStackIngredient.deserialize((JsonElement)itemInput);
        JsonArray gasInput = JSONUtils.func_151202_d((JsonObject)json, (String)"gasInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"gasInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"gasInput");
        GasStackIngredient gasIngredient = GasStackIngredient.deserialize((JsonElement)gasInput);
        GasStack output = SerializerHelper.getGasStack(json, "output");
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, itemIngredient, gasIngredient, output);
    }

    public T read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ItemStackIngredient itemInput = ItemStackIngredient.read(buffer);
            GasStackIngredient gasInput = GasStackIngredient.read(buffer);
            GasStack output = GasStack.readFromPacket(buffer);
            return this.factory.create(recipeId, itemInput, gasInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading itemstack gas to gas recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull T recipe) {
        try {
            ((ItemStackGasToGasRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing itemstack gas to gas recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    public static interface IFactory<T extends ItemStackGasToGasRecipe> {
        public T create(ResourceLocation var1, ItemStackIngredient var2, GasStackIngredient var3, GasStack var4);
    }
}

