/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SawmillRecipeSerializer<T extends SawmillRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public SawmillRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @Nonnull
    public T read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        ItemStackIngredient inputIngredient = ItemStackIngredient.deserialize((JsonElement)input);
        ItemStack mainOutput = ItemStack.field_190927_a;
        ItemStack secondaryOutput = ItemStack.field_190927_a;
        double secondaryChance = 0.0;
        if (json.has("secondaryOutput") || json.has("secondaryChance")) {
            if (json.has("mainOutput") && (mainOutput = SerializerHelper.getItemStack(json, "mainOutput")).func_190926_b()) {
                throw new JsonSyntaxException("Sawmill main recipe output must not be empty, if it is defined.");
            }
            JsonElement chance = json.get("secondaryChance");
            if (!JSONUtils.func_188175_b((JsonElement)chance)) {
                throw new JsonSyntaxException("Expected secondaryChance to be a number greater than zero.");
            }
            secondaryChance = chance.getAsJsonPrimitive().getAsDouble();
            if (secondaryChance <= 0.0 || secondaryChance > 1.0) {
                throw new JsonSyntaxException("Expected secondaryChance to be greater than zero, and less than or equal to one.");
            }
            secondaryOutput = SerializerHelper.getItemStack(json, "secondaryOutput");
            if (secondaryOutput.func_190926_b()) {
                throw new JsonSyntaxException("Sawmill secondary recipe output must not be empty, if there is no main output.");
            }
        } else {
            mainOutput = SerializerHelper.getItemStack(json, "mainOutput");
            if (mainOutput.func_190926_b()) {
                throw new JsonSyntaxException("Sawmill main recipe output must not be empty, if there is no secondary output.");
            }
        }
        return this.factory.create(recipeId, inputIngredient, mainOutput, secondaryOutput, secondaryChance);
    }

    public T read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ItemStackIngredient inputIngredient = ItemStackIngredient.read(buffer);
            ItemStack mainOutput = buffer.func_150791_c();
            ItemStack secondaryOutput = buffer.func_150791_c();
            double secondaryChance = buffer.readDouble();
            return this.factory.create(recipeId, inputIngredient, mainOutput, secondaryOutput, secondaryChance);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading sawmill recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull T recipe) {
        try {
            ((SawmillRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing sawmill recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    public static interface IFactory<T extends SawmillRecipe> {
        public T create(ResourceLocation var1, ItemStackIngredient var2, ItemStack var3, ItemStack var4, double var5);
    }
}

