/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.block.IHasTileEntity;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.sustained.ISustainedInventory;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemRecipeData
implements RecipeUpgradeData<ItemRecipeData> {
    private final List<IInventorySlot> slots;

    ItemRecipeData(ListNBT slots) {
        int count = DataHandlerUtils.getMaxId(slots, "Slot");
        this.slots = new ArrayList<IInventorySlot>(count);
        for (int i = 0; i < count; ++i) {
            this.slots.add(new DummyInventorySlot());
        }
        DataHandlerUtils.readSlots(this.slots, slots);
    }

    ItemRecipeData(List<IInventorySlot> slots) {
        this.slots = slots;
    }

    @Override
    @Nullable
    public ItemRecipeData merge(ItemRecipeData other) {
        ArrayList<IInventorySlot> allSlots = new ArrayList<IInventorySlot>(this.slots.size() + other.slots.size());
        allSlots.addAll(this.slots);
        allSlots.addAll(other.slots);
        return new ItemRecipeData(allSlots);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.slots.isEmpty()) {
            return true;
        }
        Item item = stack.func_77973_b();
        boolean isBin = item instanceof ItemBlockBin;
        Optional capability = MekanismUtils.toOptional(stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY));
        final ArrayList<DummyInventorySlot> slots = new ArrayList<DummyInventorySlot>();
        if (capability.isPresent()) {
            IItemHandler itemHandler = (IItemHandler)capability.get();
            int i = 0;
            while (i < itemHandler.getSlots()) {
                int slot = i++;
                slots.add(new DummyInventorySlot(itemHandler.getSlotLimit(slot), itemStack -> itemHandler.isItemValid(slot, itemStack), isBin));
            }
        } else if (item instanceof BlockItem) {
            TileEntity tileEntity;
            TileEntityMekanism tile = null;
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof IHasTileEntity && (tileEntity = ((IHasTileEntity)block).getTileType().func_200968_a()) instanceof TileEntityMekanism) {
                tile = (TileEntityMekanism)tileEntity;
            }
            if (tile == null || !tile.persistInventory()) {
                return false;
            }
            TileEntityMekanism mekTile = tile;
            int i = 0;
            while (i < tile.getSlots()) {
                int slot = i++;
                slots.add(new DummyInventorySlot(tile.getSlotLimit(slot), itemStack -> mekTile.isItemValid(slot, (ItemStack)itemStack), isBin));
            }
        } else {
            if (item instanceof ISustainedInventory) {
                for (IInventorySlot slot : this.slots) {
                    if (slot.isEmpty()) continue;
                    ((ISustainedInventory)stack.func_77973_b()).setInventory(DataHandlerUtils.writeSlots(this.slots), stack);
                    return true;
                }
                return true;
            }
            return false;
        }
        if (slots.isEmpty()) {
            return true;
        }
        IMekanismInventory outputHandler = new IMekanismInventory(){

            @Override
            @Nonnull
            public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
                return slots;
            }

            @Override
            public void onContentsChanged() {
            }
        };
        boolean hasData = false;
        for (IInventorySlot slot : this.slots) {
            if (slot.isEmpty()) continue;
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)outputHandler, (ItemStack)slot.getStack(), (boolean)false).func_190926_b()) {
                return false;
            }
            hasData = true;
        }
        if (hasData) {
            ((ISustainedInventory)stack.func_77973_b()).setInventory(DataHandlerUtils.writeSlots(slots), stack);
        }
        return true;
    }

    private static class DummyInventorySlot
    extends BasicInventorySlot {
        private DummyInventorySlot() {
            this(Integer.MAX_VALUE, alwaysTrue, true);
        }

        private DummyInventorySlot(int capacity, Predicate<@NonNull ItemStack> validator, boolean isBin) {
            super(capacity, alwaysTrueBi, alwaysTrueBi, validator, null, 0, 0);
            if (isBin) {
                this.obeyStackLimit = false;
            }
        }
    }
}

