/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class SecurityRecipeData
implements RecipeUpgradeData<SecurityRecipeData> {
    private final UUID owner;
    private final ISecurityTile.SecurityMode mode;

    SecurityRecipeData(UUID owner, ISecurityTile.SecurityMode mode) {
        this.owner = owner;
        this.mode = mode;
    }

    @Override
    @Nullable
    public SecurityRecipeData merge(SecurityRecipeData other) {
        if (this.owner.equals(other.owner)) {
            return new SecurityRecipeData(this.owner, ISecurityTile.SecurityMode.byIndexStatic(Math.max(this.mode.ordinal(), other.mode.ordinal())));
        }
        return null;
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        ISecurityItem securityItem = (ISecurityItem)stack.func_77973_b();
        securityItem.setOwnerUUID(stack, this.owner);
        securityItem.setSecurity(stack, this.mode);
        return true;
    }
}

