/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tags;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeRegistryTagCollection<T extends IForgeRegistryEntry<T>>
extends TagCollection<T> {
    private final IForgeRegistry<T> registry;

    public ForgeRegistryTagCollection(IForgeRegistry<T> registry, String location, String type) {
        super(key -> Optional.ofNullable(registry.getValue(key)), location, false, type);
        this.registry = registry;
    }

    public void write(PacketBuffer buffer) {
        Map tagMap = this.func_200039_c();
        buffer.func_150787_b(tagMap.size());
        for (Map.Entry entry : tagMap.entrySet()) {
            buffer.func_192572_a((ResourceLocation)entry.getKey());
            Tag tag = (Tag)entry.getValue();
            buffer.func_150787_b(tag.func_199885_a().size());
            for (IForgeRegistryEntry element : tag.func_199885_a()) {
                ResourceLocation key = this.registry.getKey(element);
                if (key == null) continue;
                buffer.func_192572_a(key);
            }
        }
    }

    public void read(PacketBuffer buffer) {
        Object2ObjectOpenHashMap tagMap = new Object2ObjectOpenHashMap();
        int tagCount = buffer.func_150792_a();
        for (int i = 0; i < tagCount; ++i) {
            ResourceLocation resourceLocation = buffer.func_192575_l();
            int elementCount = buffer.func_150792_a();
            Tag.Builder builder = Tag.Builder.func_200047_a();
            for (int j = 0; j < elementCount; ++j) {
                IForgeRegistryEntry value = this.registry.getValue(buffer.func_192575_l());
                if (value == null) continue;
                builder.func_200048_a((Object)value);
            }
            tagMap.put(resourceLocation, builder.func_200051_a(resourceLocation));
        }
        this.func_223507_b((Map)tagMap);
    }
}

