/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackToGasCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.GasInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.prefab.TileEntityOperationalMachine;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;

public class TileEntityChemicalOxidizer
extends TileEntityOperationalMachine<ItemStackToGasRecipe> {
    public static final long MAX_GAS = 10000L;
    public BasicGasTank gasTank;
    public long gasOutput = 256L;
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler = InputHelper.getInputHandler(this.inputSlot);
    private MachineEnergyContainer<TileEntityChemicalOxidizer> energyContainer;
    private InputInventorySlot inputSlot;
    private GasInventorySlot outputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityChemicalOxidizer() {
        super(MekanismBlocks.CHEMICAL_OXIDIZER, 100);
        this.outputHandler = OutputHelper.getOutputHandler(this.gasTank);
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGas(this::getDirection);
        this.gasTank = BasicGasTank.output(10000L, this);
        builder.addTank(this.gasTank, RelativeSide.RIGHT);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipe(recipe -> recipe.getInput().testType(item)), this, 26, 36);
        builder.addSlot(this.inputSlot, RelativeSide.LEFT);
        this.outputSlot = GasInventorySlot.drain(this.gasTank, this, 155, 25);
        builder.addSlot(this.outputSlot, RelativeSide.RIGHT);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemicalOxidizer)this).func_145831_w(), this, 155, 5);
        builder.addSlot(this.energySlot, RelativeSide.BOTTOM, RelativeSide.TOP);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.outputSlot.drainTank();
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        GasUtils.emit(EnumSet.of(this.getRightSide()), this.gasTank, this, this.gasOutput);
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ItemStackToGasRecipe> getRecipeType() {
        return MekanismRecipeType.OXIDIZING;
    }

    @Override
    @Nullable
    public CachedRecipe<ItemStackToGasRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public ItemStackToGasRecipe getRecipe(int cacheIndex) {
        ItemStack stack = this.inputHandler.getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        return (ItemStackToGasRecipe)this.findFirstRecipe(recipe -> recipe.test(stack));
    }

    @Override
    @Nullable
    public CachedRecipe<ItemStackToGasRecipe> createNewCachedRecipe(@Nonnull ItemStackToGasRecipe recipe, int cacheIndex) {
        return new ItemStackToGasCachedRecipe(recipe, this.inputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    public MachineEnergyContainer<TileEntityChemicalOxidizer> getEnergyContainer() {
        return this.energyContainer;
    }
}

