/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.FluidGasToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.FluidGasToGasCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.GasInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ITileCachedRecipeHolder;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityChemicalWasher
extends TileEntityMekanism
implements ITileCachedRecipeHolder<FluidGasToGasRecipe> {
    public static final long MAX_GAS = 10000L;
    public static final int MAX_FLUID = 10000;
    public BasicFluidTank fluidTank;
    public BasicGasTank inputTank;
    public BasicGasTank outputTank;
    public long gasOutput = 256L;
    public CachedRecipe<FluidGasToGasRecipe> cachedRecipe;
    public FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler = InputHelper.getInputHandler(this.fluidTank);
    private final IInputHandler<@NonNull GasStack> gasInputHandler = InputHelper.getInputHandler(this.inputTank);
    private MachineEnergyContainer<TileEntityChemicalWasher> energyContainer;
    private FluidInventorySlot fluidSlot;
    private OutputInventorySlot fluidOutputSlot;
    private GasInventorySlot gasOutputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityChemicalWasher() {
        super(MekanismBlocks.CHEMICAL_WASHER);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank);
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGas(this::getDirection);
        this.inputTank = BasicGasTank.input(10000L, gas -> this.containsRecipe(recipe -> recipe.getGasInput().testType((Gas)gas)), this);
        builder.addTank(this.inputTank, RelativeSide.LEFT);
        this.outputTank = BasicGasTank.output(10000L, this);
        builder.addTank(this.outputTank, RelativeSide.RIGHT);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = BasicFluidTank.input(10000, fluid -> this.containsRecipe(recipe -> recipe.getFluidInput().testType(fluid)), this);
        builder.addTank(this.fluidTank, RelativeSide.TOP);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.fluidSlot = FluidInventorySlot.fill(this.fluidTank, this, 180, 71);
        builder.addSlot(this.fluidSlot, RelativeSide.LEFT);
        this.fluidOutputSlot = OutputInventorySlot.at(this, 180, 102);
        builder.addSlot(this.fluidOutputSlot, RelativeSide.TOP);
        this.gasOutputSlot = GasInventorySlot.drain(this.outputTank, this, 155, 56);
        builder.addSlot(this.gasOutputSlot, RelativeSide.RIGHT);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemicalWasher)this).func_145831_w(), this, 155, 5);
        builder.addSlot(this.energySlot);
        this.gasOutputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.fluidSlot.setSlotType(ContainerSlotType.INPUT);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.fluidSlot.fillTank(this.fluidOutputSlot);
        this.gasOutputSlot.drainTank();
        FloatingLong prev = this.energyContainer.getEnergy().copyAsConst();
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        this.clientEnergyUsed = prev.subtract(this.energyContainer.getEnergy());
        GasUtils.emit(EnumSet.of(this.getRightSide()), this.outputTank, this, this.gasOutput);
    }

    @Override
    @Nonnull
    public MekanismRecipeType<FluidGasToGasRecipe> getRecipeType() {
        return MekanismRecipeType.WASHING;
    }

    @Override
    @Nullable
    public CachedRecipe<FluidGasToGasRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public FluidGasToGasRecipe getRecipe(int cacheIndex) {
        GasStack gasStack = this.gasInputHandler.getInput();
        if (gasStack.isEmpty()) {
            return null;
        }
        FluidStack fluid = this.fluidInputHandler.getInput();
        if (fluid.isEmpty()) {
            return null;
        }
        return (FluidGasToGasRecipe)this.findFirstRecipe(recipe -> recipe.test(fluid, gasStack));
    }

    @Override
    @Nullable
    public CachedRecipe<FluidGasToGasRecipe> createNewCachedRecipe(@Nonnull FluidGasToGasRecipe recipe, int cacheIndex) {
        return new FluidGasToGasCachedRecipe(recipe, this.fluidInputHandler, this.gasInputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setOnFinish(() -> this.markDirty(false)).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), currentMax);
        });
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getCapacity());
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    public MachineEnergyContainer<TileEntityChemicalWasher> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(() -> this.clientEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }
}

