/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ElectrolysisCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.ElectrolyticSeparatorEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.GasInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.interfaces.ITileCachedRecipeHolder;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityElectrolyticSeparator
extends TileEntityMekanism
implements ITileCachedRecipeHolder<ElectrolysisRecipe>,
IHasGasMode {
    public BasicFluidTank fluidTank;
    private static final long MAX_GAS = 2400L;
    public BasicGasTank leftTank;
    public BasicGasTank rightTank;
    public long output = 512L;
    public TileEntityGasTank.GasMode dumpLeft = TileEntityGasTank.GasMode.IDLE;
    public TileEntityGasTank.GasMode dumpRight = TileEntityGasTank.GasMode.IDLE;
    public CachedRecipe<ElectrolysisRecipe> cachedRecipe;
    public FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private final IOutputHandler<@NonNull Pair<GasStack, GasStack>> outputHandler;
    private final IInputHandler<@NonNull FluidStack> inputHandler = InputHelper.getInputHandler(this.fluidTank);
    private ElectrolyticSeparatorEnergyContainer energyContainer;
    private FluidInventorySlot fluidSlot;
    private GasInventorySlot leftOutputSlot;
    private GasInventorySlot rightOutputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityElectrolyticSeparator() {
        super(MekanismBlocks.ELECTROLYTIC_SEPARATOR);
        this.outputHandler = OutputHelper.getOutputHandler((IGasTank)this.leftTank, this.rightTank);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = BasicFluidTank.input(24000, fluid -> this.containsRecipe(recipe -> recipe.getInput().testType(fluid)), this);
        builder.addTank(this.fluidTank, RelativeSide.FRONT, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGas(this::getDirection);
        this.leftTank = BasicGasTank.output(2400L, this);
        builder.addTank(this.leftTank, RelativeSide.LEFT);
        this.rightTank = BasicGasTank.output(2400L, this);
        builder.addTank(this.rightTank, RelativeSide.RIGHT);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = ElectrolyticSeparatorEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.fluidSlot = FluidInventorySlot.fill(this.fluidTank, this, 26, 35);
        builder.addSlot(this.fluidSlot, RelativeSide.FRONT);
        this.leftOutputSlot = GasInventorySlot.drain(this.leftTank, this, 59, 52);
        builder.addSlot(this.leftOutputSlot, RelativeSide.LEFT);
        this.rightOutputSlot = GasInventorySlot.drain(this.rightTank, this, 101, 52);
        builder.addSlot(this.rightOutputSlot, RelativeSide.RIGHT);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityElectrolyticSeparator)this).func_145831_w(), this, 143, 35);
        builder.addSlot(this.energySlot, RelativeSide.BACK);
        this.fluidSlot.setSlotType(ContainerSlotType.INPUT);
        this.leftOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.rightOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.fluidSlot.fillTank();
        this.leftOutputSlot.drainTank();
        this.rightOutputSlot.drainTank();
        FloatingLong prev = this.energyContainer.getEnergy().copyAsConst();
        CachedRecipe<ElectrolysisRecipe> oldCache = this.cachedRecipe;
        this.cachedRecipe = this.getUpdatedCache(0);
        if (oldCache != this.cachedRecipe) {
            this.energyContainer.updateEnergyPerTick();
        }
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        this.clientEnergyUsed = prev.subtract(this.energyContainer.getEnergy());
        long dumpAmount = 8L * (long)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        this.handleTank(this.leftTank, this.dumpLeft, this.getLeftSide(), dumpAmount);
        this.handleTank(this.rightTank, this.dumpRight, this.getRightSide(), dumpAmount);
    }

    private void handleTank(IGasTank tank, TileEntityGasTank.GasMode mode, Direction side, long dumpAmount) {
        if (!tank.isEmpty()) {
            if (mode == TileEntityGasTank.GasMode.DUMPING) {
                tank.shrinkStack(dumpAmount, Action.EXECUTE);
            } else {
                long needed;
                GasUtils.emit(EnumSet.of(side), tank, this, this.output);
                if (mode == TileEntityGasTank.GasMode.DUMPING_EXCESS && (needed = tank.getNeeded()) < this.output) {
                    tank.shrinkStack(this.output - needed, Action.EXECUTE);
                }
            }
        }
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ElectrolysisRecipe> getRecipeType() {
        return MekanismRecipeType.SEPARATING;
    }

    @Override
    @Nullable
    public CachedRecipe<ElectrolysisRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public ElectrolysisRecipe getRecipe(int cacheIndex) {
        FluidStack fluid = this.inputHandler.getInput();
        if (fluid.isEmpty()) {
            return null;
        }
        return (ElectrolysisRecipe)this.findFirstRecipe(recipe -> recipe.test(fluid));
    }

    @Override
    @Nullable
    public CachedRecipe<ElectrolysisRecipe> createNewCachedRecipe(@Nonnull ElectrolysisRecipe recipe, int cacheIndex) {
        return new ElectrolysisCachedRecipe(recipe, this.inputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setOnFinish(() -> this.markDirty(false)).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), currentMax);
        });
    }

    public ElectrolyticSeparatorEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumpLeft = (TileEntityGasTank.GasMode)this.dumpLeft.getNext();
            this.markDirty(false);
        } else if (tank == 1) {
            this.dumpRight = (TileEntityGasTank.GasMode)this.dumpRight.getNext();
            this.markDirty(false);
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "dumpLeft", TileEntityGasTank.GasMode::byIndexStatic, mode -> {
            this.dumpLeft = mode;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "dumpRight", TileEntityGasTank.GasMode::byIndexStatic, mode -> {
            this.dumpRight = mode;
        });
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("dumpLeft", this.dumpLeft.ordinal());
        nbtTags.func_74768_a("dumpRight", this.dumpRight.ordinal());
        return nbtTags;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableEnum.create(TileEntityGasTank.GasMode::byIndexStatic, TileEntityGasTank.GasMode.IDLE, () -> this.dumpLeft, value -> {
            this.dumpLeft = value;
        }));
        container.track(SyncableEnum.create(TileEntityGasTank.GasMode::byIndexStatic, TileEntityGasTank.GasMode.IDLE, () -> this.dumpRight, value -> {
            this.dumpRight = value;
        }));
        container.track(SyncableFloatingLong.create(() -> this.clientEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }
}

