/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public abstract class TileEntityMultiblock<T extends SynchronizedData<T>>
extends TileEntityMekanism
implements IMultiblock<T> {
    @Nullable
    public T structure;
    private boolean prevStructure;
    public boolean clientHasStructure;
    public boolean isRendering;
    public MultiblockCache<T> cachedData = this.getNewCache();
    @Nullable
    public UUID cachedID = null;

    public TileEntityMultiblock(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    public void removeStructure() {
        this.structure = null;
        this.invalidateCachedCapabilities();
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (!this.clientHasStructure && !this.playersUsing.isEmpty()) {
            for (PlayerEntity player : new ObjectOpenHashSet((Collection)this.playersUsing)) {
                player.func_71053_j();
            }
        }
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.structure == null) {
            if (!this.playersUsing.isEmpty()) {
                for (PlayerEntity player : new ObjectOpenHashSet((Collection)this.playersUsing)) {
                    player.func_71053_j();
                }
            }
            if (this.cachedID != null) {
                this.getManager().updateCache(this);
            }
            if (this.ticker == 5) {
                this.doUpdate();
            }
            if (this.prevStructure) {
                this.structureChanged();
                this.prevStructure = false;
            }
            this.isRendering = false;
        } else {
            if (!this.prevStructure) {
                this.structureChanged();
                this.prevStructure = true;
            }
            ((SynchronizedData)this.structure).didTick = false;
            if (((SynchronizedData)this.structure).inventoryID != null) {
                this.cachedData.sync(this.structure);
                this.cachedID = ((SynchronizedData)this.structure).inventoryID;
                this.getManager().updateCache(this);
            }
        }
    }

    private void structureChanged() {
        if (this.structure != null && !((SynchronizedData)this.structure).hasRenderer) {
            ((SynchronizedData)this.structure).hasRenderer = true;
            this.isRendering = true;
            ((SynchronizedData)this.structure).forceUpdateComparatorLevel();
            ((SynchronizedData)this.structure).notifyAllUpdateComparator(this.field_145850_b);
        }
        Coord4D thisCoord = Coord4D.get(this);
        for (Direction side : EnumUtils.DIRECTIONS) {
            Coord4D obj = thisCoord.offset(side);
            if (this.structure != null && (((SynchronizedData)this.structure).locations.contains(obj) || ((SynchronizedData)this.structure).internalLocations.contains(obj))) continue;
            BlockPos pos = obj.getPos();
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.field_145850_b, pos);
            if (this.field_145850_b.func_175623_d(pos) || tile != null && tile.getClass() == this.getClass() || tile instanceof IStructuralMultiblock || tile instanceof IMultiblock) continue;
            MekanismUtils.notifyNeighborofChange(this.field_145850_b, pos, this.func_174877_v());
        }
        this.sendUpdatePacket();
        if (this.structure == null) {
            this.markDirtyComparator();
        }
    }

    @Override
    public void doUpdate() {
        if (!(this.isRemote() || this.structure != null && ((SynchronizedData)this.structure).didTick)) {
            this.getProtocol().doUpdate();
            if (this.structure != null) {
                ((SynchronizedData)this.structure).didTick = true;
            }
        }
    }

    @Override
    public ActionResultType onActivate(PlayerEntity player, Hand hand, ItemStack stack) {
        if (player.func_225608_bj_() || this.structure == null) {
            return ActionResultType.PASS;
        }
        return this.openGui(player);
    }

    @Nonnull
    protected abstract T getNewStructure();

    public abstract MultiblockCache<T> getNewCache();

    protected abstract UpdateProtocol<T> getProtocol();

    public abstract MultiblockManager<T> getManager();

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74757_a("rendering", this.isRendering);
        updateTag.func_74757_a("hasStructure", this.structure != null);
        if (this.structure != null && this.isRendering) {
            updateTag.func_74768_a("height", ((SynchronizedData)this.structure).volHeight);
            updateTag.func_74768_a("width", ((SynchronizedData)this.structure).volWidth);
            updateTag.func_74768_a("length", ((SynchronizedData)this.structure).volLength);
            if (((SynchronizedData)this.structure).renderLocation != null) {
                updateTag.func_218657_a("renderLocation", (INBT)((SynchronizedData)this.structure).renderLocation.write(new CompoundNBT()));
            }
            if (((SynchronizedData)this.structure).inventoryID != null) {
                updateTag.func_186854_a("inventoryID", ((SynchronizedData)this.structure).inventoryID);
            }
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        if (this.structure == null) {
            this.structure = this.getNewStructure();
        }
        NBTUtils.setBooleanIfPresent(tag, "rendering", value -> {
            this.isRendering = value;
        });
        NBTUtils.setBooleanIfPresent(tag, "hasStructure", value -> {
            this.clientHasStructure = value;
        });
        if (this.isRendering) {
            if (this.clientHasStructure) {
                NBTUtils.setIntIfPresent(tag, "height", value -> {
                    ((SynchronizedData)this.structure).volHeight = value;
                });
                NBTUtils.setIntIfPresent(tag, "width", value -> {
                    ((SynchronizedData)this.structure).volWidth = value;
                });
                NBTUtils.setIntIfPresent(tag, "length", value -> {
                    ((SynchronizedData)this.structure).volLength = value;
                });
                NBTUtils.setCoord4DIfPresent(tag, "renderLocation", value -> {
                    ((SynchronizedData)this.structure).renderLocation = value;
                });
                ((SynchronizedData)this.structure).inventoryID = tag.func_186855_b("inventoryID") ? tag.func_186857_a("inventoryID") : null;
                if (((SynchronizedData)this.structure).renderLocation != null && !this.prevStructure) {
                    Mekanism.proxy.doMultiblockSparkle(this, ((SynchronizedData)this.structure).renderLocation.getPos(), ((SynchronizedData)this.structure).volLength, ((SynchronizedData)this.structure).volWidth, ((SynchronizedData)this.structure).volHeight, tile -> MultiblockManager.areEqual(this, tile));
                }
            } else {
                this.isRendering = false;
            }
            this.prevStructure = this.clientHasStructure;
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        if (this.structure == null && nbtTags.func_186855_b("inventoryID")) {
            this.cachedID = nbtTags.func_186857_a("inventoryID");
            this.cachedData.load(nbtTags);
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.cachedID != null) {
            nbtTags.func_186854_a("inventoryID", this.cachedID);
            this.cachedData.save(nbtTags);
        }
        return nbtTags;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.clientHasStructure && this.structure != null && this.isRendering && ((SynchronizedData)this.structure).renderLocation != null) {
            BlockPos corner1 = ((SynchronizedData)this.structure).renderLocation.getPos();
            BlockPos corner2 = corner1.func_177965_g(((SynchronizedData)this.structure).volLength + 1).func_177970_e(((SynchronizedData)this.structure).volWidth + 1).func_177981_b(((SynchronizedData)this.structure).volHeight - 1);
            return new AxisAlignedBB(corner1, corner2);
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public boolean persistInventory() {
        return false;
    }

    @Override
    public T getSynchronizedData() {
        return this.structure;
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        return side -> this.structure == null ? Collections.emptyList() : ((SynchronizedData)this.structure).getInventorySlots(side);
    }
}

