/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.sustained.ISustainedData;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.chemical.QuantumEntangloporterGasTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.QuantumEntangloporterEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.fluid.QuantumEntangloporterFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.heat.QuantumEntangloporterHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.QuantumEntangloporterInventorySlotHolder;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.FrequencyType;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.ProxiedSlotInfo;
import mekanism.common.tile.interfaces.IHasFrequency;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityQuantumEntangloporter
extends TileEntityMekanism
implements ISideConfiguration,
IFrequencyHandler,
ISustainedData,
IChunkLoader,
IHasFrequency {
    public InventoryFrequency frequency;
    public List<Frequency> publicCache = new ArrayList<Frequency>();
    public List<Frequency> privateCache = new ArrayList<Frequency>();
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.GAS, TransmissionType.ENERGY, TransmissionType.HEAT);
    public TileComponentChunkLoader<TileEntityQuantumEntangloporter> chunkLoaderComponent;
    private double lastTransferLoss;
    private double lastEnvironmentLoss;

    public TileEntityQuantumEntangloporter() {
        super(MekanismBlocks.QUANTUM_ENTANGLOPORTER);
        ConfigInfo heatConfig;
        ConfigInfo energyConfig;
        ConfigInfo gasConfig;
        ConfigInfo fluidConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            Supplier<List<IInventorySlot>> slotSupplier = () -> this.hasFrequency() ? this.frequency.getInventorySlots(null) : Collections.emptyList();
            itemConfig.addSlotInfo(DataType.INPUT, new ProxiedSlotInfo.Inventory(true, false, slotSupplier));
            itemConfig.addSlotInfo(DataType.OUTPUT, new ProxiedSlotInfo.Inventory(false, true, slotSupplier));
            itemConfig.fill(DataType.INPUT);
            itemConfig.setDataType(RelativeSide.FRONT, DataType.OUTPUT);
        }
        if ((fluidConfig = this.configComponent.getConfig(TransmissionType.FLUID)) != null) {
            Supplier<List<IExtendedFluidTank>> tankSupplier = () -> this.hasFrequency() ? this.frequency.getFluidTanks(null) : Collections.emptyList();
            fluidConfig.addSlotInfo(DataType.INPUT, new ProxiedSlotInfo.Fluid(true, false, tankSupplier));
            fluidConfig.addSlotInfo(DataType.OUTPUT, new ProxiedSlotInfo.Fluid(false, true, tankSupplier));
            fluidConfig.fill(DataType.INPUT);
            fluidConfig.setDataType(RelativeSide.FRONT, DataType.OUTPUT);
        }
        if ((gasConfig = this.configComponent.getConfig(TransmissionType.GAS)) != null) {
            Supplier<List<IGasTank>> tankSupplier = () -> this.hasFrequency() ? this.frequency.getGasTanks(null) : Collections.emptyList();
            gasConfig.addSlotInfo(DataType.INPUT, new ProxiedSlotInfo.Gas(true, false, tankSupplier));
            gasConfig.addSlotInfo(DataType.OUTPUT, new ProxiedSlotInfo.Gas(false, true, tankSupplier));
            gasConfig.fill(DataType.INPUT);
            gasConfig.setDataType(RelativeSide.FRONT, DataType.OUTPUT);
        }
        if ((energyConfig = this.configComponent.getConfig(TransmissionType.ENERGY)) != null) {
            Supplier<List<IEnergyContainer>> containerSupplier = () -> this.hasFrequency() ? this.frequency.getEnergyContainers(null) : Collections.emptyList();
            energyConfig.addSlotInfo(DataType.INPUT, new ProxiedSlotInfo.Energy(true, false, containerSupplier));
            energyConfig.addSlotInfo(DataType.OUTPUT, new ProxiedSlotInfo.Energy(false, true, containerSupplier));
            energyConfig.fill(DataType.INPUT);
            energyConfig.setDataType(RelativeSide.FRONT, DataType.OUTPUT);
        }
        if ((heatConfig = this.configComponent.getConfig(TransmissionType.HEAT)) != null) {
            Supplier<List<IHeatCapacitor>> capacitorSupplier = () -> this.hasFrequency() ? this.frequency.getHeatCapacitors(null) : Collections.emptyList();
            heatConfig.addSlotInfo(DataType.INPUT, new ProxiedSlotInfo.Heat(true, false, capacitorSupplier));
            heatConfig.fill(DataType.INPUT);
            heatConfig.setCanEject(false);
        }
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, itemConfig);
        this.ejectorComponent.setOutputData(TransmissionType.FLUID, fluidConfig);
        this.ejectorComponent.setOutputData(TransmissionType.GAS, gasConfig);
        this.chunkLoaderComponent = new TileComponentChunkLoader<TileEntityQuantumEntangloporter>(this);
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        return new QuantumEntangloporterGasTankHolder(this);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return new QuantumEntangloporterFluidTankHolder(this);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        return new QuantumEntangloporterEnergyContainerHolder(this);
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        return new QuantumEntangloporterHeatCapacitorHolder(this);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        return new QuantumEntangloporterInventorySlotHolder(this);
    }

    @Override
    protected void onUpdateServer() {
        ConfigInfo info;
        super.onUpdateServer();
        if (this.hasFrequency() && (info = this.configComponent.getConfig(TransmissionType.ENERGY)) != null && info.isEjecting()) {
            CableUtils.emit(info.getSidesForData(DataType.OUTPUT), this.frequency.storedEnergy, (TileEntity)this);
        }
        this.updateHeatCapacitors(null);
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastTransferLoss = loss.getAdjacentTransfer();
        this.lastEnvironmentLoss = loss.getEnvironmentTransfer();
        FrequencyManager manager = this.getManager(this.frequency);
        InventoryFrequency lastFreq = this.frequency;
        if (manager != null) {
            if (this.frequency != null && !this.frequency.valid) {
                this.frequency = (InventoryFrequency)manager.validateFrequency(this.getSecurity().getOwnerUUID(), Coord4D.get(this), this.frequency);
                MekanismUtils.notifyLoadedNeighborsOfTileChange(this.func_145831_w(), this.func_174877_v());
                this.markDirty(false);
            }
            if (this.frequency != null) {
                this.frequency = (InventoryFrequency)manager.update(Coord4D.get(this), this.frequency);
                if (this.frequency == null) {
                    MekanismUtils.notifyLoadedNeighborsOfTileChange(this.func_145831_w(), this.func_174877_v());
                    this.markDirty(false);
                }
            }
        } else {
            this.frequency = null;
            if (lastFreq != null) {
                MekanismUtils.notifyLoadedNeighborsOfTileChange(this.func_145831_w(), this.func_174877_v());
                this.markDirty(false);
            }
        }
    }

    public boolean hasFrequency() {
        return this.frequency != null && this.frequency.valid;
    }

    @Override
    public void func_145843_s() {
        FrequencyManager manager;
        super.func_145843_s();
        if (!this.isRemote() && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies) {
            return this.getSecurity().getFrequency();
        }
        return this.frequency;
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.getSecurity().getOwnerUUID() == null || freq == null) {
            return null;
        }
        if (freq.isPublic()) {
            return Mekanism.publicEntangloporters;
        }
        if (!Mekanism.privateEntangloporters.containsKey(this.getSecurity().getOwnerUUID())) {
            FrequencyManager manager = new FrequencyManager(FrequencyType.INVENTORY, "Entangloporter", this.getSecurity().getOwnerUUID());
            Mekanism.privateEntangloporters.put(this.getSecurity().getOwnerUUID(), manager);
            if (!this.isRemote()) {
                manager.createOrLoad();
            }
        }
        return Mekanism.privateEntangloporters.get(this.getSecurity().getOwnerUUID());
    }

    @Override
    public void setFrequency(String name, boolean publicFreq) {
        FrequencyManager manager = this.getManager(new InventoryFrequency(name, null).setPublic(publicFreq));
        manager.deactivate(Coord4D.get(this));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.name.equals(name)) continue;
            this.frequency = (InventoryFrequency)freq;
            this.frequency.activeCoords.add(Coord4D.get(this));
            MekanismUtils.notifyLoadedNeighborsOfTileChange(this.func_145831_w(), this.func_174877_v());
            this.invalidateCachedCapabilities();
            this.markDirty(false);
            return;
        }
        Frequency freq = new InventoryFrequency(name, this.getSecurity().getOwnerUUID()).setPublic(publicFreq);
        freq.activeCoords.add(Coord4D.get(this));
        manager.addFrequency(freq);
        this.frequency = (InventoryFrequency)freq;
        this.invalidateCachedCapabilities();
        MekanismUtils.notifyLoadedNeighborsOfTileChange(this.func_145831_w(), this.func_174877_v());
        this.markDirty(false);
    }

    @Override
    public void removeFrequency(String name, boolean publicFreq) {
        FrequencyManager manager = this.getManager(new InventoryFrequency(name, null).setPublic(publicFreq));
        if (manager != null) {
            manager.remove(name, this.getSecurity().getOwnerUUID());
            this.invalidateCachedCapabilities();
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_150297_b("frequency", 10)) {
            this.frequency = new InventoryFrequency(nbtTags.func_74775_l("frequency"), false);
            this.frequency.valid = false;
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.frequency != null) {
            CompoundNBT frequencyTag = new CompoundNBT();
            this.frequency.write(frequencyTag);
            nbtTags.func_218657_a("frequency", (INBT)frequencyTag);
        }
        return nbtTags;
    }

    @Override
    public boolean persistInventory() {
        return false;
    }

    @Override
    public boolean persists(SubstanceType type) {
        return false;
    }

    @Override
    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        ISlotInfo slotInfo;
        if (this.hasFrequency() && (slotInfo = this.configComponent.getSlotInfo(TransmissionType.HEAT, side)) != null && slotInfo.canInput()) {
            TileEntity adj = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
            return MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_HANDLER_CAPABILITY, side.func_176734_d())).orElse(null);
        }
        return null;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public Direction getOrientation() {
        return this.getDirection();
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    public TileComponentChunkLoader<TileEntityQuantumEntangloporter> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        return Collections.singleton(new ChunkPos(this.func_174877_v()));
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.frequency != null) {
            ItemDataUtils.setCompound(itemStack, "frequency", this.frequency.getIdentity().serialize());
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        Frequency.Identity freq = Frequency.Identity.load(ItemDataUtils.getCompound(itemStack, "frequency"));
        if (freq != null) {
            this.setFrequency(freq.name, freq.publicFreq);
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("frequency.name", "frequency.name");
        remap.put("frequency.publicFreq", "frequency.publicFreq");
        return remap;
    }

    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    private List<Frequency> getPublicFrequencies() {
        return this.isRemote() ? this.publicCache : Mekanism.publicEntangloporters.getFrequencies();
    }

    private List<Frequency> getPrivateFrequencies() {
        if (this.isRemote()) {
            return this.privateCache;
        }
        UUID ownerUUID = this.getSecurity().getOwnerUUID();
        if (ownerUUID == null) {
            return Collections.emptyList();
        }
        if (Mekanism.privateEntangloporters.containsKey(ownerUUID)) {
            return Mekanism.privateEntangloporters.get(ownerUUID).getFrequencies();
        }
        FrequencyManager manager = new FrequencyManager(FrequencyType.INVENTORY, "Entangloporter", this.getSecurity().getOwnerUUID());
        Mekanism.privateEntangloporters.put(this.getSecurity().getOwnerUUID(), manager);
        if (!this.isRemote()) {
            manager.createOrLoad();
        }
        return manager.getFrequencies();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track(SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
        container.track(SyncableFrequency.create(() -> this.frequency, value -> {
            this.frequency = value;
        }));
        container.track(SyncableFrequencyList.create(this::getPublicFrequencies, value -> {
            this.publicCache = value;
        }));
        container.track(SyncableFrequencyList.create(this::getPrivateFrequencies, value -> {
            this.privateCache = value;
        }));
    }
}

