/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.heat.HeatAPI;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.energy.ResistiveHeaterEnergyContainer;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;

public class TileEntityResistiveHeater
extends TileEntityMekanism {
    private float soundScale = 1.0f;
    public double lastEnvironmentLoss;
    private ResistiveHeaterEnergyContainer energyContainer;
    private BasicHeatCapacitor heatCapacitor;
    private EnergyInventorySlot energySlot;

    public TileEntityResistiveHeater() {
        super(MekanismBlocks.RESISTIVE_HEATER);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = ResistiveHeaterEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.LEFT, RelativeSide.RIGHT);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(this::getDirection);
        this.heatCapacitor = BasicHeatCapacitor.create(100.0, 5.0, 100.0, this);
        builder.addCapacitor(this.heatCapacitor);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityResistiveHeater)this).func_145831_w(), this, 15, 35);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        FloatingLong toUse = FloatingLong.ZERO;
        if (MekanismUtils.canFunction(this) && !(toUse = this.energyContainer.extract(this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL)).isZero()) {
            this.heatCapacitor.handleHeat(toUse.multiply(MekanismConfig.general.resistiveHeaterEfficiency.get()).doubleValue());
            this.energyContainer.extract(toUse, Action.EXECUTE, AutomationType.INTERNAL);
        }
        this.setActive(!toUse.isZero());
        HeatAPI.HeatTransfer transfer = this.simulate();
        this.lastEnvironmentLoss = transfer.getEnvironmentTransfer();
        float newSoundScale = toUse.divide(100000L).floatValue();
        if ((double)Math.abs(newSoundScale - this.soundScale) > 0.01) {
            this.soundScale = newSoundScale;
            this.sendUpdatePacket();
        }
    }

    public void setEnergyUsageFromPacket(FloatingLong floatingLong) {
        this.energyContainer.updateEnergyUsage(floatingLong);
        this.markDirty(false);
    }

    @Override
    public float getVolume() {
        return (float)Math.sqrt(this.soundScale);
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    public MachineEnergyContainer<TileEntityResistiveHeater> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableDouble.create(() -> this.lastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74776_a("soundScale", this.soundScale);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setFloatIfPresent(tag, "soundScale", value -> {
            this.soundScale = value;
        });
    }
}

