/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.world.IBlockReader;

public class TileEntityStructuralGlass
extends TileEntityUpdateable
implements IStructuralMultiblock {
    public Coord4D master;

    public TileEntityStructuralGlass() {
        super(MekanismTileEntityTypes.STRUCTURAL_GLASS.getTileEntityType());
    }

    @Override
    public ActionResultType onActivate(PlayerEntity player, Hand hand, ItemStack stack) {
        if (this.master != null) {
            TileEntity masterTile = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.master.getPos());
            if (masterTile instanceof IMultiblock) {
                return ((IMultiblock)masterTile).onActivate(player, hand, stack);
            }
            this.master = null;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void doUpdate() {
        if (this.master != null) {
            TileEntity masterTile = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.master.getPos());
            if (masterTile instanceof IMultiblock) {
                ((IMultiblock)masterTile).doUpdate();
            } else {
                this.master = null;
            }
        } else {
            IMultiblock<?> multiblock = new ControllerFinder().find();
            if (multiblock != null) {
                multiblock.doUpdate();
            }
        }
    }

    @Override
    @Nullable
    public Coord4D getController() {
        return this.master;
    }

    @Override
    public boolean canInterface(TileEntity controller) {
        return true;
    }

    @Override
    public void setController(Coord4D coord) {
        this.master = coord;
    }

    public class ControllerFinder {
        public IMultiblock<?> found;
        public Set<Coord4D> iterated = new ObjectOpenHashSet();

        public void loop(Coord4D pos) {
            if (this.iterated.size() > 2048 || this.found != null) {
                return;
            }
            this.iterated.add(pos);
            for (Direction side : EnumUtils.DIRECTIONS) {
                Coord4D coord = pos.offset(side);
                TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)TileEntityStructuralGlass.this.func_145831_w(), coord.getPos());
                if (this.iterated.contains(coord)) continue;
                if (tile instanceof IMultiblock) {
                    this.found = (IMultiblock)tile;
                    return;
                }
                if (!(tile instanceof IStructuralMultiblock)) continue;
                this.loop(coord);
            }
        }

        public IMultiblock<?> find() {
            this.loop(Coord4D.get(TileEntityStructuralGlass.this));
            return this.found;
        }
    }
}

