/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.block.basic.BlockTeleporterFrame;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.FrequencyType;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.interfaces.IHasFrequency;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TileEntityTeleporter
extends TileEntityMekanism
implements IChunkLoader,
IFrequencyHandler,
IHasFrequency {
    private AxisAlignedBB teleportBounds = null;
    public Set<UUID> didTeleport = new ObjectOpenHashSet();
    public int teleDelay = 0;
    public boolean shouldRender;
    public Frequency frequency;
    public List<Frequency> publicCache = new ArrayList<Frequency>();
    public List<Frequency> privateCache = new ArrayList<Frequency>();
    public byte status = 0;
    private TileComponentChunkLoader<TileEntityTeleporter> chunkLoaderComponent = new TileComponentChunkLoader<TileEntityTeleporter>(this);
    private MachineEnergyContainer<TileEntityTeleporter> energyContainer;
    private EnergyInventorySlot energySlot;

    public TileEntityTeleporter() {
        super(MekanismBlocks.TELEPORTER);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityTeleporter)this).func_145831_w(), this, 153, 7);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    public static void alignPlayer(ServerPlayerEntity player, Coord4D coord) {
        Direction side = null;
        float yaw = player.field_70177_z;
        BlockPos upperPos = coord.getPos().func_177984_a();
        for (Direction iterSide : MekanismUtils.SIDE_DIRS) {
            if (!player.field_70170_p.func_175623_d(upperPos.func_177972_a(iterSide))) continue;
            side = iterSide;
            break;
        }
        if (side != null) {
            switch (side) {
                case NORTH: {
                    yaw = 180.0f;
                    break;
                }
                case SOUTH: {
                    yaw = 0.0f;
                    break;
                }
                case WEST: {
                    yaw = 90.0f;
                    break;
                }
                case EAST: {
                    yaw = 270.0f;
                    break;
                }
            }
        }
        player.field_71135_a.func_147364_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), yaw, player.field_70125_A);
    }

    @Override
    protected void onUpdateServer() {
        FrequencyManager manager;
        super.onUpdateServer();
        if (this.teleportBounds == null) {
            this.resetBounds();
        }
        if ((manager = this.getManager(this.frequency)) != null) {
            if (this.frequency != null && !this.frequency.valid) {
                this.frequency = manager.validateFrequency(this.getSecurity().getOwnerUUID(), Coord4D.get(this), this.frequency);
            }
            if (this.frequency != null) {
                this.frequency = manager.update(Coord4D.get(this), this.frequency);
            }
        } else {
            this.frequency = null;
        }
        this.status = this.canTeleport();
        if (MekanismUtils.canFunction(this) && this.status == 1 && this.teleDelay == 0) {
            this.teleport();
        }
        if (this.teleDelay == 0 && !this.didTeleport.isEmpty()) {
            this.cleanTeleportCache();
        }
        boolean prevShouldRender = this.shouldRender;
        boolean bl = this.shouldRender = this.status == 1 || this.status > 4;
        if (this.shouldRender != prevShouldRender) {
            MekanismUtils.notifyLoadedNeighborsOfTileChange(this.field_145850_b, this.func_174877_v());
            this.sendUpdatePacket();
        }
        this.teleDelay = Math.max(0, this.teleDelay - 1);
        this.energySlot.fillContainerOrConvert();
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies) {
            return this.getSecurity().getFrequency();
        }
        return this.frequency;
    }

    @Nullable
    private Coord4D getClosest() {
        return this.frequency == null ? null : this.frequency.getClosestCoords(Coord4D.get(this));
    }

    @Override
    public void setFrequency(String name, boolean publicFreq) {
        FrequencyManager manager = this.getManager(new Frequency(name, null).setPublic(publicFreq));
        manager.deactivate(Coord4D.get(this));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.name.equals(name)) continue;
            this.frequency = freq;
            this.frequency.activeCoords.add(Coord4D.get(this));
            this.markDirty(false);
            return;
        }
        Frequency freq = new Frequency(name, this.getSecurity().getOwnerUUID()).setPublic(publicFreq);
        freq.activeCoords.add(Coord4D.get(this));
        manager.addFrequency(freq);
        this.frequency = freq;
        this.markDirty(false);
    }

    @Override
    public void removeFrequency(String name, boolean publicFreq) {
        FrequencyManager manager = this.getManager(new Frequency(name, null).setPublic(publicFreq));
        if (manager != null) {
            manager.remove(name, this.getSecurity().getOwnerUUID());
        }
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.getSecurity().getOwnerUUID() == null || freq == null) {
            return null;
        }
        if (freq.isPublic()) {
            return Mekanism.publicTeleporters;
        }
        if (!Mekanism.privateTeleporters.containsKey(this.getSecurity().getOwnerUUID())) {
            FrequencyManager manager = new FrequencyManager(FrequencyType.BASE, "Teleporter", this.getSecurity().getOwnerUUID());
            Mekanism.privateTeleporters.put(this.getSecurity().getOwnerUUID(), manager);
            if (!this.isRemote()) {
                manager.createOrLoad();
            }
        }
        return Mekanism.privateTeleporters.get(this.getSecurity().getOwnerUUID());
    }

    public void onChunkUnloaded() {
        FrequencyManager manager;
        super.onChunkUnloaded();
        if (!this.isRemote() && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    @Override
    public void func_145843_s() {
        FrequencyManager manager;
        super.func_145843_s();
        if (!this.isRemote() && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    private void cleanTeleportCache() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (Entity e : this.field_145850_b.func_217357_a(Entity.class, this.teleportBounds)) {
            list.add(e.func_110124_au());
        }
        ObjectOpenHashSet teleportCopy = new ObjectOpenHashSet(this.didTeleport);
        for (UUID id : teleportCopy) {
            if (list.contains(id)) continue;
            this.didTeleport.remove(id);
        }
    }

    private void resetBounds() {
        this.teleportBounds = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 3, 1));
    }

    private byte canTeleport() {
        if (!this.hasEastWestFrame() && !this.hasNorthSouthFrame()) {
            return 2;
        }
        Coord4D closestCoords = this.getClosest();
        if (closestCoords == null) {
            return 3;
        }
        FloatingLong sum = FloatingLong.ZERO;
        for (Entity entity : this.getToTeleport()) {
            sum = sum.plusEqual(TileEntityTeleporter.calculateEnergyCost(entity, closestCoords));
        }
        if (this.energyContainer.getEnergy().smallerThan(sum)) {
            return 4;
        }
        return 1;
    }

    private void teleport() {
        Coord4D closestCoords = this.getClosest();
        if (closestCoords == null) {
            return;
        }
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        ServerWorld teleWorld = currentServer.func_71218_a(closestCoords.dimension);
        TileEntityTeleporter teleporter = MekanismUtils.getTileEntity(TileEntityTeleporter.class, (IBlockReader)teleWorld, closestCoords.getPos());
        if (teleporter != null) {
            for (Entity entity : this.getToTeleport()) {
                teleporter.didTeleport.add(entity.func_110124_au());
                teleporter.teleDelay = 5;
                TileEntityTeleporter.teleportEntityTo(entity, closestCoords, teleporter);
                if (entity instanceof ServerPlayerEntity) {
                    TileEntityTeleporter.alignPlayer((ServerPlayerEntity)entity, closestCoords);
                }
                for (Coord4D coords : this.frequency.activeCoords) {
                    Mekanism.packetHandler.sendToAllTracking(new PacketPortalFX(coords), (World)currentServer.func_71218_a(coords.dimension), coords.getPos());
                }
                this.energyContainer.extract(TileEntityTeleporter.calculateEnergyCost(entity, closestCoords), Action.EXECUTE, AutomationType.INTERNAL);
                this.field_145850_b.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f, false);
            }
        }
    }

    public static void teleportEntityTo(Entity entity, final Coord4D coord, TileEntityTeleporter teleporter) {
        if (entity.field_71093_bK != coord.dimension) {
            entity.changeDimension(coord.dimension, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    Entity repositionedEntity = repositionEntity.apply(false);
                    repositionedEntity.func_70634_a((double)coord.x + 0.5, (double)(coord.y + 1), (double)coord.z + 0.5);
                    return repositionedEntity;
                }
            });
        } else {
            entity.func_70634_a((double)coord.x + 0.5, (double)(coord.y + 1), (double)coord.z + 0.5);
        }
    }

    private List<Entity> getToTeleport() {
        return this.field_145850_b == null ? Collections.emptyList() : this.field_145850_b.func_175647_a(Entity.class, this.teleportBounds, entity -> !entity.func_175149_v() && !this.didTeleport.contains(entity.func_110124_au()));
    }

    @Nonnull
    public static FloatingLong calculateEnergyCost(Entity entity, Coord4D coords) {
        FloatingLong energyCost = (FloatingLong)MekanismConfig.usage.teleporterBase.get();
        energyCost = entity.field_70170_p.func_201675_m().func_186058_p().equals(coords.dimension) ? energyCost.add(((FloatingLong)MekanismConfig.usage.teleporterDistance.get()).multiply(Math.sqrt(entity.func_70092_e((double)coords.x, (double)coords.y, (double)coords.z)))) : energyCost.add((FloatingLong)MekanismConfig.usage.teleporterDimensionPenalty.get());
        return energyCost;
    }

    public boolean hasEastWestFrame() {
        int z;
        int y;
        int x = this.func_174877_v().func_177958_n();
        return this.isFrame(x - 1, y = this.func_174877_v().func_177956_o(), z = this.func_174877_v().func_177952_p()) && this.isFrame(x + 1, y, z) && this.isFrame(x - 1, y + 1, z) && this.isFrame(x + 1, y + 1, z) && this.isFrame(x - 1, y + 2, z) && this.isFrame(x + 1, y + 2, z) && this.isFrame(x - 1, y + 3, z) && this.isFrame(x + 1, y + 3, z) && this.isFrame(x, y + 3, z);
    }

    public boolean hasNorthSouthFrame() {
        int z;
        int y;
        int x = this.func_174877_v().func_177958_n();
        return this.isFrame(x, y = this.func_174877_v().func_177956_o(), (z = this.func_174877_v().func_177952_p()) - 1) && this.isFrame(x, y, z + 1) && this.isFrame(x, y + 1, z - 1) && this.isFrame(x, y + 1, z + 1) && this.isFrame(x, y + 2, z - 1) && this.isFrame(x, y + 2, z + 1) && this.isFrame(x, y + 3, z - 1) && this.isFrame(x, y + 3, z + 1) && this.isFrame(x, y + 3, z);
    }

    public boolean isFrame(int x, int y, int z) {
        return this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() instanceof BlockTeleporterFrame;
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_150297_b("frequency", 10)) {
            this.frequency = new Frequency(nbtTags.func_74775_l("frequency"), false);
            this.frequency.valid = false;
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.frequency != null) {
            CompoundNBT frequencyTag = new CompoundNBT();
            this.frequency.write(frequencyTag);
            nbtTags.func_218657_a("frequency", (INBT)frequencyTag);
        }
        return nbtTags;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177982_a(1, 3, 1));
    }

    public TileComponentChunkLoader<TileEntityTeleporter> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        return Collections.singleton(new ChunkPos(this.func_174877_v()));
    }

    @Override
    public int getRedstoneLevel() {
        return this.shouldRender ? 15 : 0;
    }

    @Override
    public int getCurrentRedstoneLevel() {
        return this.getRedstoneLevel();
    }

    public MachineEnergyContainer<TileEntityTeleporter> getEnergyContainer() {
        return this.energyContainer;
    }

    private List<Frequency> getPublicFrequencies() {
        return this.isRemote() ? this.publicCache : Mekanism.publicTeleporters.getFrequencies();
    }

    private List<Frequency> getPrivateFrequencies() {
        if (this.isRemote()) {
            return this.privateCache;
        }
        UUID ownerUUID = this.getSecurity().getOwnerUUID();
        if (ownerUUID == null) {
            return Collections.emptyList();
        }
        if (Mekanism.privateTeleporters.containsKey(ownerUUID)) {
            return Mekanism.privateTeleporters.get(ownerUUID).getFrequencies();
        }
        FrequencyManager manager = new FrequencyManager(FrequencyType.BASE, "Teleporter", ownerUUID);
        Mekanism.privateTeleporters.put(ownerUUID, manager);
        if (!this.isRemote()) {
            manager.createOrLoad();
        }
        return manager.getFrequencies();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableByte.create(() -> this.status, value -> {
            this.status = value;
        }));
        container.track(SyncableFrequency.create(() -> this.frequency, value -> {
            this.frequency = value;
        }));
        container.track(SyncableFrequencyList.create(this::getPublicFrequencies, value -> {
            this.publicCache = value;
        }));
        container.track(SyncableFrequencyList.create(this::getPrivateFrequencies, value -> {
            this.privateCache = value;
        }));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74757_a("rendering", this.shouldRender);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setBooleanIfPresent(tag, "rendering", value -> {
            this.shouldRender = value;
        });
    }
}

