/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mekanism.api.DataHandlerUtils;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;

public enum SubstanceType {
    ENERGY("EnergyContainers", tile -> tile.getEnergyContainers(null), DataHandlerUtils::writeContainers, DataHandlerUtils::readContainers),
    FLUID("FluidTanks", tile -> tile.getFluidTanks(null), DataHandlerUtils::writeTanks, DataHandlerUtils::readTanks),
    GAS("GasTanks", tile -> tile.getGasTanks(null), DataHandlerUtils::writeTanks, DataHandlerUtils::readTanks),
    INFUSION("InfusionTanks", tile -> tile.getInfusionTanks(null), DataHandlerUtils::writeTanks, DataHandlerUtils::readTanks),
    HEAT("HeatCapacitors", tile -> tile.getHeatCapacitors(null), DataHandlerUtils::writeContainers, DataHandlerUtils::readContainers);

    private String containerTag;
    private Function<TileEntityMekanism, List<? extends INBTSerializable<CompoundNBT>>> containerSupplier;
    private Function<List<? extends INBTSerializable<CompoundNBT>>, ListNBT> writeFunction;
    private BiConsumer<List<? extends INBTSerializable<CompoundNBT>>, ListNBT> readFunction;

    private SubstanceType(String containerTag, Function<TileEntityMekanism, List<? extends INBTSerializable<CompoundNBT>>> containerSupplier, Function<List<? extends INBTSerializable<CompoundNBT>>, ListNBT> writeFunction, BiConsumer<List<? extends INBTSerializable<CompoundNBT>>, ListNBT> readFunction) {
        this.containerTag = containerTag;
        this.containerSupplier = containerSupplier;
        this.writeFunction = writeFunction;
        this.readFunction = readFunction;
    }

    public void write(TileEntityMekanism tile, CompoundNBT tag) {
        tag.func_218657_a(this.containerTag, (INBT)this.writeFunction.apply(this.containerSupplier.apply(tile)));
    }

    public void read(TileEntityMekanism tile, CompoundNBT tag) {
        this.readFunction.accept(this.containerSupplier.apply(tile), tag.func_150295_c(this.containerTag, 10));
    }

    public String getContainerTag() {
        return this.containerTag;
    }

    public Function<List<? extends INBTSerializable<CompoundNBT>>, ListNBT> getWriteFunction() {
        return this.writeFunction;
    }

    public BiConsumer<List<? extends INBTSerializable<CompoundNBT>>, ListNBT> getReadFunction() {
        return this.readFunction;
    }

    public List<? extends INBTSerializable<CompoundNBT>> getContainers(TileEntityMekanism tile) {
        return this.containerSupplier.apply(tile);
    }

    public boolean canHandle(TileEntityMekanism tile) {
        switch (this) {
            case ENERGY: {
                return tile.canHandleEnergy();
            }
            case FLUID: {
                return tile.canHandleFluid();
            }
            case GAS: {
                return tile.canHandleGas();
            }
            case INFUSION: {
                return tile.canHandleInfusion();
            }
            case HEAT: {
                return tile.canHandleHeat();
            }
        }
        return false;
    }
}

