/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigCardAccess;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ProcessInfo;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.block.machine.prefab.BlockFactoryMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.EnergySlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.ITileCachedRecipeHolder;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;

public abstract class TileEntityFactory<RECIPE extends MekanismRecipe>
extends TileEntityMekanism
implements ISideConfiguration,
IConfigCardAccess.ISpecialConfigData,
ITileCachedRecipeHolder<RECIPE> {
    private final CachedRecipe<RECIPE>[] cachedRecipes;
    private boolean[] activeStates;
    protected ProcessInfo[] processInfoSlots;
    public FactoryTier tier;
    public int[] progress;
    public int BASE_TICKS_REQUIRED = 200;
    public int ticksRequired = 200;
    protected boolean sorting;
    public FloatingLong lastUsage = FloatingLong.ZERO;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    @Nonnull
    protected FactoryType field_200663_e;
    protected MachineEnergyContainer<TileEntityFactory<?>> energyContainer;
    protected List<IInventorySlot> inputSlots;
    protected List<IInventorySlot> outputSlots;
    protected EnergyInventorySlot energySlot;

    protected TileEntityFactory(IBlockProvider blockProvider) {
        super(blockProvider);
        ConfigInfo energyConfig;
        BlockFactoryMachine.BlockFactory factoryBlock = (BlockFactoryMachine.BlockFactory)blockProvider.getBlock();
        this.field_200663_e = Attribute.get(factoryBlock, AttributeFactoryType.class).getFactoryType();
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            this.inputSlots = new ArrayList<IInventorySlot>();
            this.outputSlots = new ArrayList<IInventorySlot>();
            for (ProcessInfo info : this.processInfoSlots) {
                this.inputSlots.add(info.getInputSlot());
                this.outputSlots.add(info.getOutputSlot());
                if (info.getSecondaryOutputSlot() == null) continue;
                this.outputSlots.add(info.getSecondaryOutputSlot());
            }
            itemConfig.addSlotInfo(DataType.INPUT, new InventorySlotInfo(true, false, this.inputSlots));
            itemConfig.addSlotInfo(DataType.OUTPUT, new InventorySlotInfo(false, true, this.outputSlots));
            itemConfig.addSlotInfo(DataType.ENERGY, new InventorySlotInfo(true, true, this.energySlot));
            itemConfig.setDataType(RelativeSide.LEFT, DataType.INPUT);
            itemConfig.setDataType(RelativeSide.RIGHT, DataType.OUTPUT);
            itemConfig.setDataType(RelativeSide.BACK, DataType.ENERGY);
            IInventorySlot extraSlot = this.getExtraSlot();
            if (extraSlot != null) {
                itemConfig.addSlotInfo(DataType.EXTRA, new InventorySlotInfo(true, true, extraSlot));
                itemConfig.setDataType(RelativeSide.BOTTOM, DataType.EXTRA);
            }
        }
        if ((energyConfig = this.configComponent.getConfig(TransmissionType.ENERGY)) != null) {
            energyConfig.addSlotInfo(DataType.INPUT, new EnergySlotInfo(true, false, this.energyContainer));
            energyConfig.fill(DataType.INPUT);
            energyConfig.setCanEject(false);
        }
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, itemConfig);
        this.progress = new int[this.tier.processes];
        this.cachedRecipes = new CachedRecipe[this.tier.processes];
        this.activeStates = new boolean[this.cachedRecipes.length];
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY, this));
    }

    @Override
    protected void presetVariables() {
        this.tier = Attribute.getTier(this.getBlockType(), FactoryTier.class);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.addSlots(builder);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityFactory)this).func_145831_w(), this, 7, 13);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    protected abstract void addSlots(InventorySlotHelper var1);

    @Nullable
    protected IInventorySlot getExtraSlot() {
        return null;
    }

    @Override
    protected void onUpdateServer() {
        this.energySlot.fillContainerOrConvert();
        this.handleSecondaryFuel();
        this.sortInventory();
        FloatingLong prev = this.energyContainer.getEnergy();
        for (int i = 0; i < this.cachedRecipes.length; ++i) {
            this.cachedRecipes[i] = this.getUpdatedCache(i);
            CachedRecipe cachedRecipe = this.cachedRecipes[i];
            if (cachedRecipe != null) {
                cachedRecipe.process();
                continue;
            }
            this.activeStates[i] = false;
        }
        boolean isActive = false;
        for (boolean state : this.activeStates) {
            if (!state) continue;
            isActive = true;
            break;
        }
        this.setActive(isActive);
        this.lastUsage = prev.subtract(this.energyContainer.getEnergy());
    }

    private void sortInventory() {
        if (this.isSorting()) {
            for (int i = 0; i < this.processInfoSlots.length; ++i) {
                ProcessInfo primaryInfo = this.processInfoSlots[i];
                IInventorySlot primaryInputSlot = primaryInfo.getInputSlot();
                ItemStack stack = primaryInputSlot.getStack();
                int count = stack.func_190916_E();
                for (int j = i + 1; j < this.processInfoSlots.length; ++j) {
                    ProcessInfo checkInfo = this.processInfoSlots[j];
                    IInventorySlot checkInputSlot = checkInfo.getInputSlot();
                    ItemStack checkStack = checkInputSlot.getStack();
                    if (Math.abs(count - checkStack.func_190916_E()) < 2 || !InventoryUtils.areItemsStackable(stack, checkStack) || stack.func_190926_b() && !this.inputProducesOutput(checkInfo.getProcess(), checkStack, primaryInfo.getOutputSlot(), primaryInfo.getSecondaryOutputSlot(), true) || checkStack.func_190926_b() && !this.inputProducesOutput(primaryInfo.getProcess(), stack, checkInfo.getOutputSlot(), checkInfo.getSecondaryOutputSlot(), true)) continue;
                    int total = count + checkStack.func_190916_E();
                    ItemStack newStack = stack.func_190926_b() ? checkStack : stack;
                    primaryInputSlot.setStack(StackUtils.size(newStack, (total + 1) / 2));
                    checkInputSlot.setStack(StackUtils.size(newStack, total / 2));
                    this.markDirty(false);
                    return;
                }
            }
        }
    }

    public abstract boolean inputProducesOutput(int var1, @Nonnull ItemStack var2, @Nonnull IInventorySlot var3, @Nullable IInventorySlot var4, boolean var5);

    @Override
    @Nullable
    public CachedRecipe<RECIPE> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipes[cacheIndex];
    }

    protected void updateCachedRecipe(@Nonnull CachedRecipe<RECIPE> newCache, int cacheIndex) {
        this.cachedRecipes[cacheIndex] = newCache;
    }

    protected void setActiveState(boolean state, int cacheIndex) {
        this.activeStates[cacheIndex] = state;
    }

    protected void handleSecondaryFuel() {
    }

    public abstract boolean isValidInputItem(@Nonnull ItemStack var1);

    public int getProgress(int cacheIndex) {
        return this.progress[cacheIndex];
    }

    @Override
    public int getSavedOperatingTicks(int cacheIndex) {
        return this.getProgress(cacheIndex);
    }

    public double getScaledProgress(int i, int process) {
        return (double)this.getProgress(process) * (double)i / (double)this.ticksRequired;
    }

    public void toggleSorting() {
        this.sorting = !this.isSorting();
        this.markDirty(false);
    }

    public boolean isSorting() {
        return this.sorting;
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.sorting = nbtTags.func_74767_n("sorting");
        for (int i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = nbtTags.func_74762_e("progress" + i);
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("sorting", this.isSorting());
        for (int i = 0; i < this.tier.processes; ++i) {
            nbtTags.func_74768_a("progress" + i, this.getProgress(i));
        }
        return nbtTags;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public Direction getOrientation() {
        return this.getDirection();
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
        }
    }

    @Override
    public CompoundNBT getConfigurationData(CompoundNBT nbtTags) {
        nbtTags.func_74757_a("sorting", this.isSorting());
        return nbtTags;
    }

    @Override
    public void setConfigurationData(CompoundNBT nbtTags) {
        this.sorting = nbtTags.func_74767_n("sorting");
    }

    @Override
    public String getDataType() {
        return this.getName().func_150254_d();
    }

    public boolean hasSecondaryResourceBar() {
        return false;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    public MachineEnergyContainer<TileEntityFactory<?>> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.trackArray(this.progress);
        container.track(SyncableFloatingLong.create(() -> this.lastUsage, value -> {
            this.lastUsage = value;
        }));
        container.track(SyncableBoolean.create(this::isSorting, value -> {
            this.sorting = value;
        }));
        container.track(SyncableInt.create(() -> this.ticksRequired, value -> {
            this.ticksRequired = value;
        }));
    }
}

