/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.block.transmitter.BlockLogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.TransporterImpl;
import mekanism.common.transmitters.grid.InventoryNetwork;
import mekanism.common.upgrade.transmitter.LogisticalTransporterUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityLogisticalTransporter
extends TileEntityTransmitter<TileEntity, InventoryNetwork, Void> {
    public final TransporterTier tier;
    private int delay = 0;
    private int delayCount = 0;

    public TileEntityLogisticalTransporter(IBlockProvider blockProvider) {
        super(blockProvider);
        Block block = blockProvider.getBlock();
        this.tier = block instanceof BlockLogisticalTransporter ? Attribute.getTier(blockProvider.getBlock(), TransporterTier.class) : TransporterTier.BASIC;
        this.transmitterDelegate = new TransporterImpl(this);
        this.addCapabilityResolver(BasicCapabilityResolver.persistent(Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, this::getTransmitter));
    }

    @Override
    public boolean handlesRedstone() {
        return false;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.LOGISTICAL_TRANSPORTER;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ITEM;
    }

    @Override
    public TileEntity getCachedAcceptor(Direction side) {
        return this.getCachedTile(side);
    }

    @Override
    public boolean isValidTransmitter(TileEntity tile) {
        Optional<ILogisticalTransporter> capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null));
        if (capability.isPresent()) {
            ILogisticalTransporter transporter = capability.get();
            if (this.getTransmitter().getColor() == null || transporter.getColor() == null || this.getTransmitter().getColor() == transporter.getColor()) {
                return super.isValidTransmitter(tile);
            }
        }
        return false;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        if (CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null).filter(transmitter -> TransmissionType.checkTransmissionType(transmitter, TransmissionType.ITEM)).isPresent()) {
            return false;
        }
        return this.isAcceptorAndListen(tile, side, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.getTransmitter().update();
    }

    public void pullItems() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.delay = 3;
        for (Direction side : this.getConnections(TileEntitySidedPipe.ConnectionType.PULL)) {
            TransitRequest request;
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
            if (tile == null || (request = TransitRequest.buildInventoryMap(tile, side, this.tier.getPullAmount())).isEmpty()) continue;
            TransitRequest.TransitResponse response = this.getTransmitter().insert(tile, request, this.getTransmitter().getColor(), true, 0);
            if (!response.isEmpty()) {
                response.use(tile, side.func_176734_d());
                this.delay = 10;
                continue;
            }
            ++this.delayCount;
            this.delay = Math.min(40, (int)Math.exp(this.delayCount));
        }
    }

    @Override
    public InventoryNetwork createNewNetwork() {
        return new InventoryNetwork();
    }

    @Override
    public InventoryNetwork createNewNetworkWithID(UUID networkID) {
        return new InventoryNetwork(networkID);
    }

    @Override
    public InventoryNetwork createNetworkByMerging(Collection<InventoryNetwork> networks) {
        return new InventoryNetwork(networks);
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        this.getTransmitter().writeToUpdateTag(updateTag);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.getTransmitter().readFromUpdateTag(tag);
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        this.getTransmitter().readFromNBT(nbtTags);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        this.getTransmitter().writeToNBT(nbtTags);
        return nbtTags;
    }

    @Override
    protected ActionResultType onConfigure(PlayerEntity player, int part, Direction side) {
        TransporterUtils.incrementColor(this.getTransmitter());
        PathfinderCache.onChanged((InventoryNetwork)this.getTransmitter().getTransmitterNetwork());
        this.sendUpdatePacket();
        EnumColor color = this.getTransmitter().getColor();
        player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.TOGGLE_COLOR.translateColored(EnumColor.GRAY, color != null ? color.getColoredName() : MekanismLang.NONE)));
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        super.onRightClick(player, side);
        EnumColor color = this.getTransmitter().getColor();
        player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.CURRENT_COLOR.translateColored(EnumColor.GRAY, color != null ? color.getColoredName() : MekanismLang.NONE)));
        return ActionResultType.SUCCESS;
    }

    @Override
    public EnumColor getRenderColor() {
        return this.getTransmitter().getColor();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.isRemote()) {
            for (TransporterStack stack : this.getTransmitter().getTransit()) {
                TransporterUtils.drop(this.getTransmitter(), stack);
            }
        }
    }

    @Override
    public long getCapacity() {
        return 0L;
    }

    @Override
    public Void releaseShare() {
        return null;
    }

    @Override
    public Void getShare() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    @Nonnull
    public TransporterImpl getTransmitter() {
        return (TransporterImpl)this.transmitterDelegate;
    }

    public double getCost() {
        return (double)TransporterTier.ULTIMATE.getSpeed() / (double)this.tier.getSpeed();
    }

    @Override
    protected boolean canUpgrade(AlloyTier alloyTier) {
        return alloyTier.getBaseTier().ordinal() == this.tier.getBaseTier().ordinal() + 1;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_LOGISTICAL_TRANSPORTER.getBlock().func_176223_P());
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_LOGISTICAL_TRANSPORTER.getBlock().func_176223_P());
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_LOGISTICAL_TRANSPORTER.getBlock().func_176223_P());
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_LOGISTICAL_TRANSPORTER.getBlock().func_176223_P());
            }
        }
        return current;
    }

    @Override
    @Nullable
    protected LogisticalTransporterUpgradeData getUpgradeData() {
        return new LogisticalTransporterUpgradeData(this.redstoneReactive, this.connectionTypes, this.getTransmitter());
    }

    @Override
    protected void parseUpgradeData(@Nonnull TransmitterUpgradeData upgradeData) {
        if (upgradeData instanceof LogisticalTransporterUpgradeData) {
            LogisticalTransporterUpgradeData data = (LogisticalTransporterUpgradeData)upgradeData;
            this.redstoneReactive = data.redstoneReactive;
            this.connectionTypes = data.connectionTypes;
            this.getTransmitter().readFromNBT(data.nbt);
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    @Override
    protected void updateModelData(TransmitterModelData modelData) {
        super.updateModelData(modelData);
        if (modelData instanceof TransmitterModelData.Colorable) {
            TransmitterModelData.Colorable colorable = (TransmitterModelData.Colorable)modelData;
            colorable.setColor(this.getRenderColor() != null);
        }
    }

    @Override
    @Nonnull
    protected TransmitterModelData initModelData() {
        return new TransmitterModelData.Colorable();
    }
}

