/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public final class InventoryUtils {
    public static TransitRequest.TransitResponse putStackInInventory(TileEntity tile, TransitRequest request, Direction side, boolean force) {
        if (force && tile instanceof TileEntityLogisticalSorter) {
            return ((TileEntityLogisticalSorter)tile).sendHome(request.getSingleStack());
        }
        if (request.getItemMap().isEmpty()) {
            return request.getEmptyResponse();
        }
        Optional capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()));
        if (capability.isPresent()) {
            IItemHandler inventory = (IItemHandler)capability.get();
            for (Map.Entry<HashedItem, TransitRequest.SlotData> requestEntry : request.getItemMap().entrySet()) {
                ItemStack origInsert = StackUtils.size(requestEntry.getKey().getStack(), requestEntry.getValue().getTotalCount());
                ItemStack toInsert = origInsert.func_77946_l();
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    if (!inventory.isItemValid(i, toInsert) || !(toInsert = inventory.insertItem(i, toInsert, false)).func_190926_b()) continue;
                    return request.createResponse(origInsert, requestEntry.getValue());
                }
                if (!TransporterManager.didEmit(origInsert, toInsert)) continue;
                return request.createResponse(TransporterManager.getToUse(origInsert, toInsert), requestEntry.getValue());
            }
        }
        return request.getEmptyResponse();
    }

    public static boolean areItemsStackable(ItemStack toInsert, ItemStack inSlot) {
        if (toInsert.func_190926_b() || inSlot.func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)toInsert);
    }

    public static InvStack takeTopStack(TileEntity tile, Direction side, Finder id, int amount) {
        Optional capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()));
        if (capability.isPresent()) {
            IItemHandler inventory = (IItemHandler)capability.get();
            InvStack ret = new InvStack(tile, side.func_176734_d());
            for (int slot = inventory.getSlots() - 1; slot >= 0; --slot) {
                ItemStack stack = inventory.extractItem(slot, amount, true);
                if (stack.func_190926_b() || !id.modifies(stack) || !ret.getStack().func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)ret.getStack())) continue;
                ret.appendStack(slot, StackUtils.size(stack, Math.min(stack.func_190916_E(), amount - ret.getCount())));
                if (ret.getCount() != amount) continue;
                return ret;
            }
            return ret;
        }
        return null;
    }

    public static InvStack takeDefinedItem(TileEntity tile, Direction side, ItemStack type, int min, int max) {
        Optional capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()));
        if (capability.isPresent()) {
            InvStack ret = new InvStack(tile, side.func_176734_d());
            IItemHandler inventory = (IItemHandler)capability.get();
            for (int i = inventory.getSlots() - 1; i >= 0; --i) {
                ItemStack stack = inventory.extractItem(i, max, true);
                if (stack.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)type)) continue;
                int current = ret.getStack().func_190916_E();
                if (current + stack.func_190916_E() <= max) {
                    ret.appendStack(i, stack.func_77946_l());
                } else {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(max - current);
                    ret.appendStack(i, copy);
                }
                if (ret.getStack().func_190926_b() || ret.getStack().func_190916_E() != max) continue;
                return ret;
            }
            if (!ret.getStack().func_190926_b() && ret.getStack().func_190916_E() >= min) {
                return ret;
            }
        }
        return null;
    }

    public static boolean canInsert(TileEntity tile, EnumColor color, ItemStack itemStack, Direction side, boolean force) {
        Optional capability;
        ISideConfiguration config;
        if (force && tile instanceof TileEntityLogisticalSorter) {
            return ((TileEntityLogisticalSorter)tile).canSendHome(itemStack);
        }
        if (!force && tile instanceof ISideConfiguration && (config = (ISideConfiguration)tile).getEjector().hasStrictInput()) {
            Direction tileSide = config.getOrientation();
            EnumColor configColor = config.getEjector().getInputColor(RelativeSide.fromDirections(tileSide, side.func_176734_d()));
            if (configColor != null && configColor != color) {
                return false;
            }
        }
        if ((capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()))).isPresent()) {
            IItemHandler inventory = (IItemHandler)capability.get();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack rejects;
                if (!inventory.isItemValid(i, itemStack) || !TransporterManager.didEmit(itemStack, rejects = inventory.insertItem(i, itemStack, true))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static IItemHandler assertItemHandler(String desc, TileEntity tile, Direction side) {
        Optional capability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side));
        if (capability.isPresent()) {
            return (IItemHandler)capability.get();
        }
        Mekanism.logger.warn("'" + desc + "' was wrapped around a non-IItemHandler inventory. This should not happen!", (Throwable)new Exception());
        if (tile == null) {
            Mekanism.logger.warn(" - null tile");
        } else {
            Mekanism.logger.warn(" - details: " + tile + " " + tile.func_174877_v());
        }
        return null;
    }

    public static boolean isItemHandler(TileEntity tile, Direction side) {
        return CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).isPresent();
    }
}

