/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.WorldConfig;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismFeatures;
import mekanism.common.registries.MekanismPlacements;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class GenHandler {
    private static ConfiguredFeature<?, ?> COPPER_FEATURE;
    private static ConfiguredFeature<?, ?> COPPER_RETROGEN_FEATURE;
    private static ConfiguredFeature<?, ?> TIN_FEATURE;
    private static ConfiguredFeature<?, ?> TIN_RETROGEN_FEATURE;
    private static ConfiguredFeature<?, ?> OSMIUM_FEATURE;
    private static ConfiguredFeature<?, ?> OSMIUM_RETROGEN_FEATURE;
    private static ConfiguredFeature<?, ?> SALT_FEATURE;
    private static ConfiguredFeature<?, ?> SALT_RETROGEN_FEATURE;

    public static void setupWorldGeneration() {
        COPPER_FEATURE = GenHandler.getOreFeature(MekanismBlocks.COPPER_ORE, MekanismConfig.world.copper, (Feature<OreFeatureConfig>)Feature.field_202290_aj);
        TIN_FEATURE = GenHandler.getOreFeature(MekanismBlocks.TIN_ORE, MekanismConfig.world.tin, (Feature<OreFeatureConfig>)Feature.field_202290_aj);
        OSMIUM_FEATURE = GenHandler.getOreFeature(MekanismBlocks.OSMIUM_ORE, MekanismConfig.world.osmium, (Feature<OreFeatureConfig>)Feature.field_202290_aj);
        SALT_FEATURE = GenHandler.getSaltFeature(MekanismBlocks.SALT_BLOCK, MekanismConfig.world.salt, (Placement<FrequencyConfig>)Placement.field_215016_b);
        if (MekanismConfig.world.enableRegeneration.get()) {
            COPPER_RETROGEN_FEATURE = GenHandler.getOreFeature(MekanismBlocks.COPPER_ORE, MekanismConfig.world.copper, (Feature<OreFeatureConfig>)MekanismFeatures.ORE_RETROGEN.getFeature());
            TIN_RETROGEN_FEATURE = GenHandler.getOreFeature(MekanismBlocks.TIN_ORE, MekanismConfig.world.tin, (Feature<OreFeatureConfig>)MekanismFeatures.ORE_RETROGEN.getFeature());
            OSMIUM_RETROGEN_FEATURE = GenHandler.getOreFeature(MekanismBlocks.OSMIUM_ORE, MekanismConfig.world.osmium, (Feature<OreFeatureConfig>)MekanismFeatures.ORE_RETROGEN.getFeature());
            SALT_RETROGEN_FEATURE = GenHandler.getSaltFeature(MekanismBlocks.SALT_BLOCK, MekanismConfig.world.salt, (Placement<FrequencyConfig>)MekanismPlacements.TOP_SOLID_RETROGEN.getPlacement());
        }
        ForgeRegistries.BIOMES.forEach(biome -> {
            if (GenHandler.isValidBiome(biome)) {
                GenHandler.addFeature(biome, COPPER_FEATURE);
                GenHandler.addFeature(biome, TIN_FEATURE);
                GenHandler.addFeature(biome, OSMIUM_FEATURE);
                GenHandler.addFeature(biome, SALT_FEATURE);
            }
        });
    }

    private static boolean isValidBiome(Biome biome) {
        return biome.func_201856_r() != Biome.Category.THEEND && biome.func_201856_r() != Biome.Category.NETHER;
    }

    private static void addFeature(Biome biome, @Nullable ConfiguredFeature<?, ?> feature) {
        if (feature != null) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature);
        }
    }

    @Nullable
    private static ConfiguredFeature<?, ?> getOreFeature(IBlockProvider blockProvider, WorldConfig.OreConfig oreConfig, Feature<OreFeatureConfig> feature) {
        if (oreConfig.shouldGenerate.get()) {
            return feature.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, blockProvider.getBlock().func_176223_P(), oreConfig.maxVeinSize.get())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(oreConfig.perChunk.get(), oreConfig.bottomOffset.get(), oreConfig.topOffset.get(), oreConfig.maxHeight.get())));
        }
        return null;
    }

    @Nullable
    private static ConfiguredFeature<?, ?> getSaltFeature(IBlockProvider blockProvider, WorldConfig.SaltConfig saltConfig, Placement<FrequencyConfig> placement) {
        if (saltConfig.shouldGenerate.get()) {
            BlockState state = blockProvider.getBlock().func_176223_P();
            return Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(state, saltConfig.maxVeinSize.get(), saltConfig.ySize.get(), (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), state}))).func_227228_a_(placement.func_227446_a_((IPlacementConfig)new FrequencyConfig(saltConfig.perChunk.get())));
        }
        return null;
    }

    public static boolean generate(ServerWorld world, Random random, int chunkX, int chunkZ) {
        BlockPos blockPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        Biome biome = world.func_226691_t_(blockPos);
        boolean generated = false;
        if (GenHandler.isValidBiome(biome) && world.func_217354_b(chunkX, chunkZ)) {
            generated = GenHandler.placeFeature(COPPER_RETROGEN_FEATURE, world, random, blockPos);
            generated |= GenHandler.placeFeature(TIN_RETROGEN_FEATURE, world, random, blockPos);
            generated |= GenHandler.placeFeature(OSMIUM_RETROGEN_FEATURE, world, random, blockPos);
            generated |= GenHandler.placeFeature(SALT_RETROGEN_FEATURE, world, random, blockPos);
        }
        return generated;
    }

    private static boolean placeFeature(@Nullable ConfiguredFeature<?, ?> feature, ServerWorld world, Random random, BlockPos blockPos) {
        if (feature != null) {
            feature.func_222734_a((IWorld)world, world.func_72863_F().func_201711_g(), random, blockPos);
            return true;
        }
        return false;
    }
}

