/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncPacket {
    private boolean canTeleport;
    private List<Biome> allowedBiomes;

    public SyncPacket() {
    }

    public SyncPacket(boolean canTeleport, List<Biome> allowedBiomes) {
        this.canTeleport = canTeleport;
        this.allowedBiomes = allowedBiomes;
    }

    public SyncPacket(PacketBuffer buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedBiomes = new ArrayList<Biome>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.allowedBiomes.add(BiomeUtils.getBiomeForID(buf.readInt()));
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedBiomes.size());
        for (Biome biome : this.allowedBiomes) {
            buf.writeInt(BiomeUtils.getIDForBiome(biome));
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NaturesCompass.canTeleport = this.canTeleport;
            NaturesCompass.allowedBiomes = this.allowedBiomes;
        });
        ctx.get().setPacketHandled(true);
    }
}

