/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigTemplates {

    public static class BiomeStructureConfig
    extends StructureConfig {
        private final ForgeConfigSpec.ConfigValue<String> biomeString;
        private final ForgeConfigSpec.BooleanValue isWhitelist;
        private List<Biome> biomes = new ArrayList<Biome>();

        public BiomeStructureConfig(ForgeConfigSpec.Builder builder, String name, double defaultProbability, int defaultSpacing, int defaultOffset, String defaultBiomesString, boolean defaultIsWhitelist) {
            super(builder, name, defaultProbability, defaultSpacing, defaultOffset);
            this.biomeString = builder.comment("A biome filter to determine where the structure should generate. Works with the biome dictionary (#overworld) and \"not\" statements (!plains). These can be combined (!#nether). Operates in the order presented. So \"#forest, !flower_forest\" will add all forests and then remove the flower forest.").define(name + ".biomes", (Object)defaultBiomesString);
            this.isWhitelist = builder.comment("How should the code treate biomes? true = whitelist, false = blacklist. Biomes defined with ! do the opposite.").define(name + ".is_whitelist", defaultIsWhitelist);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        }

        public BiomeStructureConfig(ForgeConfigSpec.Builder builder, String name, double defaultProbability, int defaultSpacing, int defaultOffset, String defaultBiomesString) {
            this(builder, name, defaultProbability, defaultSpacing, defaultOffset, defaultBiomesString, true);
        }

        @SubscribeEvent
        protected void onConfigLoad(ModConfig.ModConfigEvent event) {
            this.biomes = BiomeStructureConfig.parseBiomes((String)this.biomeString.get());
        }

        public List<Biome> getBiomes() {
            return this.biomes;
        }

        public boolean isBiomeAllowed(Biome biome) {
            return this.biomes.contains(biome) == ((Boolean)this.isWhitelist.get()).booleanValue();
        }

        public static List<Biome> parseBiomes(String key) {
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            Arrays.asList(key.replace(" ", "").split(",")).stream().forEach(s -> {
                boolean not = s.startsWith("!");
                boolean isTag = s.replace("!", "").startsWith("#");
                String biomeString = s.replace("!", "").replace("#", "");
                if (!isTag) {
                    ResourceLocation biome2 = new ResourceLocation(biomeString);
                    if (ForgeRegistries.BIOMES.containsKey(biome2)) {
                        BiomeStructureConfig.updateBiomeList(biomes, (Biome)ForgeRegistries.BIOMES.getValue(biome2), not);
                    }
                } else if (BiomeDictionary.Type.getType((String)biomeString, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) != null) {
                    BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.getType((String)biomeString, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).forEach(biome -> BiomeStructureConfig.updateBiomeList(biomes, biome, not));
                }
            });
            return biomes;
        }

        protected static void updateBiomeList(List<Biome> biomes, Biome biome, boolean not) {
            if (not) {
                if (biomes.contains(biome)) {
                    biomes.remove(biome);
                }
            } else if (!biomes.contains(biome)) {
                biomes.add(biome);
            }
        }
    }

    public static class StructureConfig {
        private final ForgeConfigSpec.DoubleValue probability;
        private final ForgeConfigSpec.IntValue spacing;
        private final ForgeConfigSpec.IntValue offset;

        public StructureConfig(ForgeConfigSpec.Builder builder, String name, double defaultProbability, int defaultSpacing, int defaultOffset) {
            this.probability = builder.comment("Chance of generating in an allowed chunk").defineInRange(name + ".probability", defaultProbability, 0.0, 1.0);
            this.spacing = builder.comment("Spacing between structures").defineInRange(name + ".spacing", defaultSpacing, 1, Integer.MAX_VALUE);
            this.offset = builder.comment("Offsets the spacing of the structures randomly").defineInRange(name + ".offset", defaultOffset, 0, Integer.MAX_VALUE);
        }

        public double getProbability() {
            return (Double)this.probability.get();
        }

        public int getSpacing() {
            return (Integer)this.spacing.get();
        }

        public int getOffset() {
            return (Integer)this.offset.get();
        }
    }
}

