/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.entity.EntityMagicLandmine;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;

public final class BlockHighlightRenderHandler {
    private BlockHighlightRenderHandler() {
    }

    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult pos = mc.field_71476_x;
        MatrixStack ms = event.getMatrixStack();
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderSystem.disableCull();
        ms.func_227860_a_();
        if (Botania.proxy.isClientPlayerWearingMonocle() && pos != null && pos.func_216346_c() == RayTraceResult.Type.BLOCK) {
            TileEntitySpecialFlower subtile;
            RadiusDescriptor descriptor;
            TileEntity tile;
            Optional<BlockPos> coords;
            BlockPos bPos = ((BlockRayTraceResult)pos).func_216350_a();
            ItemStack stackHeld = PlayerHelper.getFirstHeldItem((PlayerEntity)mc.field_71439_g, ModItems.twigWand);
            if (!stackHeld.func_190926_b() && ItemTwigWand.getBindMode(stackHeld) && (coords = ItemTwigWand.getBindingAttempt(stackHeld)).isPresent()) {
                bPos = coords.get();
            }
            if ((tile = mc.field_71441_e.func_175625_s(bPos)) instanceof TileEntitySpecialFlower && (descriptor = (subtile = (TileEntitySpecialFlower)tile).getRadius()) != null) {
                if (descriptor.isCircle()) {
                    BlockHighlightRenderHandler.renderCircle(ms, (IRenderTypeBuffer)buffers, descriptor.getSubtileCoords(), descriptor.getCircleRadius());
                } else {
                    BlockHighlightRenderHandler.renderRectangle(ms, (IRenderTypeBuffer)buffers, descriptor.getAABB(), true, null, (byte)32);
                }
            }
        }
        double offY = -0.0575;
        for (Entity e : mc.field_71441_e.func_217416_b()) {
            if (!(e instanceof EntityMagicLandmine)) continue;
            BlockPos bpos = e.func_180425_c();
            AxisAlignedBB aabb = new AxisAlignedBB(bpos).func_72317_d(0.0, offY, 0.0).func_72314_b(2.5, 0.0, 2.5);
            float gs = (float)(Math.sin(ClientTickHandler.total / 20.0f) + 1.0) * 0.2f + 0.6f;
            int r = (int)(105.0f * gs);
            int g = (int)(25.0f * gs);
            int b = (int)(145.0f * gs);
            int color = r << 16 | g << 8 | b;
            int alpha = 32;
            if (e.field_70173_aa < 8) {
                alpha = (int)((float)alpha * Math.min(((float)e.field_70173_aa + event.getPartialTicks()) / 8.0f, 1.0f));
            } else if (e.field_70173_aa > 47) {
                alpha = (int)((float)alpha * Math.min(1.0f - ((float)(e.field_70173_aa - 47) + event.getPartialTicks()) / 8.0f, 1.0f));
            }
            BlockHighlightRenderHandler.renderRectangle(ms, (IRenderTypeBuffer)buffers, aabb, false, color, (byte)alpha);
            offY += 0.001;
        }
        ms.func_227865_b_();
        buffers.func_228461_a_();
    }

    private static void renderRectangle(MatrixStack ms, IRenderTypeBuffer buffers, AxisAlignedBB aabb, boolean inner, @Nullable Integer color, byte alpha) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82615_a();
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82617_b();
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82616_c();
        ms.func_227860_a_();
        ms.func_227861_a_(aabb.field_72340_a - renderPosX, aabb.field_72338_b - renderPosY, aabb.field_72339_c - renderPosZ);
        if (color == null) {
            color = MathHelper.func_181758_c((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float f = 0.0625f;
        float x = (float)(aabb.field_72336_d - aabb.field_72340_a - (double)f);
        float z = (float)(aabb.field_72334_f - aabb.field_72339_c - (double)f);
        IVertexBuilder buffer = buffers.getBuffer(RenderHelper.RECTANGLE);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, x, f, f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        buffer.func_227888_a_(mat, f, f, f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        buffer.func_227888_a_(mat, f, f, z).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        buffer.func_227888_a_(mat, x, f, z).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        if (inner) {
            float f1 = f + f / 4.0f;
            alpha = (byte)(alpha * 2);
            buffer.func_227888_a_(mat, x += f, f1, 0.0f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
            buffer.func_227888_a_(mat, 0.0f, f1, 0.0f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
            buffer.func_227888_a_(mat, 0.0f, f1, z += f).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
            buffer.func_227888_a_(mat, x, f1, z).func_225586_a_(r, g, b, (int)alpha).func_181675_d();
        }
        ms.func_227865_b_();
    }

    private static void renderCircle(MatrixStack ms, IRenderTypeBuffer buffers, BlockPos center, double radius) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82615_a();
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82617_b();
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82616_c();
        ms.func_227860_a_();
        double x = (double)center.func_177958_n() + 0.5;
        double y = center.func_177956_o();
        double z = (double)center.func_177952_p() + 0.5;
        ms.func_227861_a_(x - renderPosX, y - renderPosY, z - renderPosZ);
        int color = MathHelper.func_181758_c((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int alpha = 32;
        float f = 0.0625f;
        int totalAngles = 360;
        int drawAngles = 360;
        int step = totalAngles / drawAngles;
        radius -= (double)f;
        IVertexBuilder buffer = buffers.getBuffer(RenderHelper.CIRCLE);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        Runnable centerFunc = () -> buffer.func_227888_a_(mat, 0.0f, f, 0.0f).func_225586_a_(r, g, b, alpha).func_181675_d();
        ArrayList<Runnable> vertexFuncs = new ArrayList<Runnable>();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> buffer.func_227888_a_(mat, xp, f, zp).func_225586_a_(r, g, b, alpha).func_181675_d());
        }
        RenderHelper.triangleFan(centerFunc, vertexFuncs);
        radius += (double)f;
        float f1 = f + f / 4.0f;
        int alpha2 = 64;
        centerFunc = () -> buffer.func_227888_a_(mat, 0.0f, f1, 0.0f).func_225586_a_(r, g, b, alpha2).func_181675_d();
        vertexFuncs.clear();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> buffer.func_227888_a_(mat, xp, f1, zp).func_225586_a_(r, g, b, alpha2).func_181675_d());
        }
        RenderHelper.triangleFan(centerFunc, vertexFuncs);
        ms.func_227865_b_();
    }
}

