/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.registry.Registry;
import vazkii.botania.client.fx.ModParticles;

public class SparkleParticleData
implements IParticleData {
    public final float size;
    public final float r;
    public final float g;
    public final float b;
    public final int m;
    public final boolean noClip;
    public final boolean fake;
    public final boolean corrupt;
    public static final IParticleData.IDeserializer<SparkleParticleData> DESERIALIZER = new IParticleData.IDeserializer<SparkleParticleData>(){

        @Nonnull
        public SparkleParticleData deserialize(@Nonnull ParticleType<SparkleParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            int m = reader.readInt();
            reader.expect(' ');
            boolean noClip = reader.readBoolean();
            reader.expect(' ');
            boolean fake = reader.readBoolean();
            reader.expect(' ');
            boolean corrupt = reader.readBoolean();
            return new SparkleParticleData(size, r, g, b, m, noClip, fake, corrupt);
        }

        public SparkleParticleData read(@Nonnull ParticleType<SparkleParticleData> type, PacketBuffer buf) {
            return new SparkleParticleData(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
        }
    };

    public static SparkleParticleData noClip(float size, float r, float g, float b, int m) {
        return new SparkleParticleData(size, r, g, b, m, true, false, false);
    }

    public static SparkleParticleData fake(float size, float r, float g, float b, int m) {
        return new SparkleParticleData(size, r, g, b, m, false, true, false);
    }

    public static SparkleParticleData corrupt(float size, float r, float g, float b, int m) {
        return new SparkleParticleData(size, r, g, b, m, false, false, true);
    }

    public static SparkleParticleData sparkle(float size, float r, float g, float b, int m) {
        return new SparkleParticleData(size, r, g, b, m, false, false, false);
    }

    private SparkleParticleData(float size, float r, float g, float b, int m, boolean noClip, boolean fake, boolean corrupt) {
        this.size = size;
        this.r = r;
        this.g = g;
        this.b = b;
        this.m = m;
        this.noClip = noClip;
        this.fake = fake;
        this.corrupt = corrupt;
    }

    @Nonnull
    public ParticleType<SparkleParticleData> func_197554_b() {
        return ModParticles.SPARKLE;
    }

    public void func_197553_a(PacketBuffer buf) {
        buf.writeFloat(this.size);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
        buf.writeInt(this.m);
        buf.writeBoolean(this.noClip);
        buf.writeBoolean(this.fake);
        buf.writeBoolean(this.corrupt);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d %s %s %s", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.size), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), this.m, this.noClip, this.fake, this.corrupt);
    }
}

