/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.brewery;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.client.integration.jei.JEIBotaniaPlugin;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.ModItems;

public class BreweryRecipeCategory
implements IRecipeCategory<IBrewRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("botania", "brewery");
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final String localizedName;

    public BreweryRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("botania", "textures/gui/nei_brewery.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 166, 65);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.brewery", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.brewery));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IBrewRecipe> getRecipeClass() {
        return IBrewRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IBrewRecipe recipe, IIngredients iIngredients) {
        ImmutableList.Builder inputBuilder = ImmutableList.builder();
        ImmutableList.Builder outputBuilder = ImmutableList.builder();
        ImmutableList.Builder containers = ImmutableList.builder();
        List<ItemStack> inputs = Arrays.asList(new ItemStack((IItemProvider)ModItems.vial), new ItemStack((IItemProvider)ModItems.flask), new ItemStack((IItemProvider)ModItems.incenseStick), new ItemStack((IItemProvider)ModItems.bloodPendant));
        for (ItemStack stack : inputs) {
            ItemStack brewed = recipe.getOutput(stack);
            if (brewed.func_190926_b()) continue;
            containers.add((Object)stack);
            outputBuilder.add((Object)brewed);
        }
        inputBuilder.add((Object)containers.build());
        for (Ingredient i : recipe.func_192400_c()) {
            inputBuilder.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)inputBuilder.build());
        iIngredients.setOutputLists(VanillaTypes.ITEM, (List)ImmutableList.of((Object)outputBuilder.build()));
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IBrewRecipe recipe, @Nonnull IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        IFocus focus = recipeLayout.getFocus();
        recipeLayout.getItemStacks().init(0, true, 39, 41);
        recipeLayout.getItemStacks().set(0, this.getItemMatchingFocus(focus, IFocus.Mode.OUTPUT, (List)outputs.get(0), (List)inputs.get(0)));
        int index = 1;
        int posX = 60;
        for (int i = 1; i < inputs.size(); ++i) {
            List o = (List)inputs.get(i);
            recipeLayout.getItemStacks().init(index, true, posX, 6);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            posX += 18;
        }
        recipeLayout.getItemStacks().init(7, false, 87, 41);
        recipeLayout.getItemStacks().set(7, this.getItemMatchingFocus(focus, IFocus.Mode.INPUT, (List)inputs.get(0), (List)outputs.get(0)));
        JEIBotaniaPlugin.addDefaultRecipeIdTooltip(recipeLayout.getItemStacks(), 7, recipe.func_199560_c());
    }

    private List<ItemStack> getItemMatchingFocus(IFocus<?> focus, IFocus.Mode mode, List<ItemStack> focused, List<ItemStack> other) {
        if (focus != null && focus.getMode() == mode) {
            ItemStack focusStack = (ItemStack)focus.getValue();
            for (int i = 0; i < focused.size(); ++i) {
                if (!focusStack.func_77969_a(focused.get(i))) continue;
                return Collections.singletonList(other.get(i));
            }
        }
        return other;
    }
}

