/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.crafting;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.item.lens.ItemLens;

public class CompositeLensRecipeWrapper
implements ICustomCraftingCategoryExtension {
    private final List<List<ItemStack>> inputs;
    private final List<Item> lenses;

    public CompositeLensRecipeWrapper(CompositeLensRecipe recipe) {
        List lensStacks = ItemTags.func_199903_a().func_199915_b(new ResourceLocation("botania", "lens")).func_199885_a().stream().map(ItemStack::new).filter(s -> !((ItemLens)s.func_77973_b()).isControlLens((ItemStack)s)).filter(s -> ((ItemLens)s.func_77973_b()).isCombinable((ItemStack)s)).collect(Collectors.toList());
        this.lenses = lensStacks.stream().map(ItemStack::func_77973_b).collect(Collectors.toList());
        this.inputs = ImmutableList.of(lensStacks, (Object)ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_151123_aH)), lensStacks);
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IIngredients ingredients) {
        ItemStack stack;
        int idx;
        recipeLayout.getItemStacks().set(ingredients);
        recipeLayout.setShapeless();
        if (recipeLayout.getFocus() != null && (idx = this.lenses.indexOf((stack = (ItemStack)recipeLayout.getFocus().getValue()).func_77973_b())) != -1) {
            this.setLenses(recipeLayout, idx, idx);
            return;
        }
        this.setLenses(recipeLayout, 1, this.lenses.size() - 1);
    }

    private void setLenses(IRecipeLayout recipeLayout, int start, int end) {
        ArrayList<ItemStack> firstInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (end >= this.lenses.size()) {
            end = this.lenses.size() - 1;
        }
        for (int i = start; i <= end; ++i) {
            ItemStack firstLens = new ItemStack((IItemProvider)this.lenses.get(i));
            for (Item secondLens : this.lenses) {
                if (secondLens == firstLens.func_77973_b()) continue;
                ItemStack secondLensStack = new ItemStack((IItemProvider)secondLens);
                if (!((ItemLens)firstLens.func_77973_b()).canCombineLenses(firstLens, secondLensStack)) continue;
                firstInput.add(firstLens);
                secondInput.add(secondLensStack);
                outputs.add(((ItemLens)firstLens.func_77973_b()).setCompositeLens(firstLens.func_77946_l(), secondLensStack));
            }
        }
        recipeLayout.getItemStacks().set(1, firstInput);
        recipeLayout.getItemStacks().set(3, secondInput);
        recipeLayout.getItemStacks().set(0, outputs);
    }
}

