/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.lens.LensPiston;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class BlockPistonRelay
extends BlockMod
implements IWandable {
    public final Map<UUID, GlobalPos> activeBindingAttempts = new HashMap<UUID, GlobalPos>();
    private final Set<GlobalPos> removeQueue = new HashSet<GlobalPos>();
    private final Set<GlobalPos> checkedCoords = new HashSet<GlobalPos>();
    private final Map<GlobalPos, Integer> coordsToCheck = new HashMap<GlobalPos, Integer>();

    public BlockPistonRelay(Block.Properties builder) {
        super(builder);
        MinecraftForge.EVENT_BUS.addListener(this::tickEnd);
    }

    public boolean func_220067_a(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, EntityType<?> type) {
        return false;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!world.field_72995_K) {
            this.mapCoords(world.func_201675_m().func_186058_p(), pos, 2);
        }
    }

    private void mapCoords(DimensionType type, BlockPos pos, int time) {
        this.coordsToCheck.put(GlobalPos.func_218179_a((DimensionType)type, (BlockPos)pos), time);
    }

    private void decrCoords(GlobalPos key) {
        int time = this.getTimeInCoords(key);
        if (time <= 0) {
            this.removeQueue.add(key);
        } else {
            this.coordsToCheck.merge(key, -1, Integer::sum);
        }
    }

    private int getTimeInCoords(GlobalPos key) {
        return this.coordsToCheck.getOrDefault(key, 0);
    }

    private TileEntity getTeAt(GlobalPos key) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        return server.func_71218_a(key.func_218177_a()).func_175625_s(key.func_218180_b());
    }

    private BlockState getStateAt(GlobalPos key) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return server.func_71218_a(key.func_218177_a()).func_180495_p(key.func_218180_b());
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        if (world.field_72995_K) {
            return false;
        }
        if (player == null || player.func_225608_bj_()) {
            BlockPistonRelay.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this));
            world.func_175655_b(pos, false);
        } else {
            GlobalPos clicked = GlobalPos.func_218179_a((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)pos.func_185334_h());
            if (ItemTwigWand.getBindMode(stack)) {
                this.activeBindingAttempts.put(player.func_110124_au(), clicked);
                world.func_184133_a(null, pos, ModSounds.ding, SoundCategory.BLOCKS, 0.5f, 1.0f);
            } else {
                BlockPos dest = WorldData.get((World)world).mapping.get(pos);
                if (dest != null) {
                    PacketHandler.sendToNearby(world, pos, (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.PARTICLE_BEAM, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p()));
                }
            }
        }
        return true;
    }

    public void tickEnd(TickEvent.ServerTickEvent event) {
        if (event.type == TickEvent.Type.SERVER && event.phase == TickEvent.Phase.END) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            for (GlobalPos s : this.coordsToCheck.keySet()) {
                BlockState state;
                ServerWorld world = server.func_71218_a(s.func_218177_a());
                WorldData data = WorldData.get((World)world);
                this.decrCoords(s);
                if (this.checkedCoords.contains(s) || (state = this.getStateAt(s)).func_177230_c() != Blocks.field_196603_bb) continue;
                boolean sticky = PistonType.STICKY == state.func_177229_b((IProperty)MovingPistonBlock.field_196345_b);
                Direction dir = ((PistonTileEntity)this.getTeAt(s)).func_195509_h();
                if (this.getTimeInCoords(s) != 0) continue;
                int x = s.func_218180_b().func_177958_n();
                int y = s.func_218180_b().func_177956_o();
                int z = s.func_218180_b().func_177952_p();
                BlockPos pos = s.func_218180_b();
                if (world.func_175623_d(pos.func_177972_a(dir))) {
                    world.func_175656_a(pos.func_177972_a(dir), ModBlocks.pistonRelay.func_176223_P());
                } else {
                    ItemStack stack = new ItemStack((IItemProvider)ModBlocks.pistonRelay);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(x + dir.func_82601_c()), (double)(y + dir.func_96559_d()), (double)(z + dir.func_82599_e()), stack));
                }
                this.checkedCoords.add(s);
                BlockPos newPos = pos.func_177972_a(dir);
                if (!data.mapping.containsKey(s.func_218180_b())) continue;
                BlockPos destPos = data.mapping.get(s.func_218180_b());
                BlockState srcState = world.func_180495_p(destPos);
                TileEntity tile = world.func_175625_s(destPos);
                if (!sticky && tile == null && srcState.func_185905_o() == PushReaction.NORMAL && srcState.func_185887_b((IBlockReader)world, destPos) != -1.0f && !srcState.isAir((IBlockReader)world, destPos)) {
                    Material destMat = world.func_180495_p(destPos.func_177972_a(dir)).func_185904_a();
                    if (world.func_175623_d(destPos.func_177972_a(dir)) || destMat.func_76222_j()) {
                        world.func_175656_a(destPos, Blocks.field_150350_a.func_176223_P());
                        world.func_175656_a(destPos.func_177972_a(dir), LensPiston.unWaterlog(srcState));
                        data.mapping.put(s.func_218180_b(), destPos.func_177972_a(dir));
                    }
                }
                destPos = data.mapping.get(s.func_218180_b());
                data.mapping.remove(s.func_218180_b());
                data.mapping.put(newPos, destPos);
                data.func_76185_a();
            }
        }
        this.coordsToCheck.keySet().removeAll(this.removeQueue);
        this.checkedCoords.removeAll(this.removeQueue);
        this.removeQueue.clear();
    }

    public static class WorldData
    extends WorldSavedData {
        private static final String ID = "PistonRelayPairs";
        public final Map<BlockPos, BlockPos> mapping = new HashMap<BlockPos, BlockPos>();

        public WorldData() {
            super(ID);
        }

        public void func_76184_a(@Nonnull CompoundNBT cmp) {
            this.mapping.clear();
            ListNBT list = cmp.func_150295_c("list", 11);
            for (int i = 0; i < list.size(); i += 2) {
                INBT from = list.get(i);
                INBT to = list.get(i + 1);
                BlockPos fromPos = BlockPos.func_218286_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)from));
                BlockPos toPos = BlockPos.func_218286_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)to));
                this.mapping.put(fromPos, toPos);
            }
        }

        @Nonnull
        public CompoundNBT func_189551_b(@Nonnull CompoundNBT cmp) {
            ListNBT list = new ListNBT();
            for (Map.Entry<BlockPos, BlockPos> e : this.mapping.entrySet()) {
                list.add(e.getKey().func_218175_a((DynamicOps)NBTDynamicOps.field_210820_a));
                list.add(e.getValue().func_218175_a((DynamicOps)NBTDynamicOps.field_210820_a));
            }
            cmp.func_218657_a("list", (INBT)list);
            return cmp;
        }

        public static WorldData get(World world) {
            WorldData data = (WorldData)((ServerWorld)world).func_217481_x().func_215753_b(WorldData::new, ID);
            if (data == null) {
                data = new WorldData();
                data.func_76185_a();
                ((ServerWorld)world).func_217481_x().func_215757_a((WorldSavedData)data);
            }
            return data;
        }
    }
}

