/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.mana.TilePool;

public class BlockPool
extends BlockModWaterloggable
implements ITileEntityProvider,
IWandHUD,
IWandable {
    private static final VoxelShape SLAB = BlockPool.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape CUTOUT = BlockPool.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape REAL_SHAPE = VoxelShapes.func_197878_a((VoxelShape)SLAB, (VoxelShape)CUTOUT, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    public final Variant variant;

    public BlockPool(Variant v, Block.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return REAL_SHAPE;
    }

    public List<ItemStack> func_220076_a(@Nonnull BlockState state, LootContext.Builder builder) {
        if (builder.func_216019_b(LootParameters.field_216288_h) instanceof TilePool && ((TilePool)builder.func_216019_b((LootParameter)LootParameters.field_216288_h)).fragile) {
            return Collections.emptyList();
        }
        return super.func_220076_a(state, builder);
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TilePool();
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity) {
            TilePool tile = (TilePool)world.func_175625_s(pos);
            tile.collideEntityItem((ItemEntity)entity);
        }
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        if (this.variant == Variant.FABULOUS) {
            return BlockRenderType.ENTITYBLOCK_ANIMATED;
        }
        return BlockRenderType.MODEL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TilePool pool = (TilePool)world.func_175625_s(pos);
        return TilePool.calculateComparatorLevel(pool.getCurrentMana(), pool.manaCap);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc, World world, BlockPos pos) {
        ((TilePool)world.func_175625_s(pos)).renderHUD(mc);
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        ((TilePool)world.func_175625_s(pos)).onWanded(player);
        return true;
    }

    public static enum Variant {
        DEFAULT,
        CREATIVE,
        DILUTED,
        FABULOUS;

    }
}

