/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;

public class SubTileTangleberrie
extends TileEntityFunctionalFlower {
    public SubTileTangleberrie(TileEntityType<?> type) {
        super(type);
    }

    public SubTileTangleberrie() {
        this(ModSubtiles.TANGLEBERRIE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getMana() > 0) {
            double x1 = (double)this.getEffectivePos().func_177958_n() + 0.5;
            double y1 = (double)this.getEffectivePos().func_177956_o() + 0.5;
            double z1 = (double)this.getEffectivePos().func_177952_p() + 0.5;
            double maxDist = this.getMaxDistance();
            double range = this.getRange();
            AxisAlignedBB boundingBox = new AxisAlignedBB(x1 - range, y1 - range, z1 - range, x1 + range + 1.0, y1 + range + 1.0, z1 + range + 1.0);
            List entities = this.func_145831_w().func_217357_a(LivingEntity.class, boundingBox);
            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, 0.5f, 0.5f, 0.5f, 3);
            for (LivingEntity entity : entities) {
                double z2;
                double y2;
                double x2;
                float distance;
                if (entity instanceof PlayerEntity || !entity.func_184222_aU() || !((double)(distance = MathHelper.pointDistanceSpace(x1, y1, z1, x2 = entity.func_226277_ct_(), y2 = entity.func_226278_cu_(), z2 = entity.func_226281_cx_())) > maxDist) || !((double)distance < range)) continue;
                MathHelper.setEntityMotionFromVector((Entity)entity, new Vector3(x1, y1, z1), this.getMotionVelocity(entity));
                if (this.func_145831_w().field_73012_v.nextInt(3) != 0) continue;
                this.field_145850_b.func_195594_a((IParticleData)data, x2 + Math.random() * (double)entity.func_213311_cf(), y2 + Math.random() * (double)entity.func_213302_cg(), z2 + Math.random() * (double)entity.func_213311_cf(), 0.0, 0.0, 0.0);
            }
            if (this.ticksExisted % 4 == 0) {
                this.addMana(-1);
                this.sync();
            }
        }
    }

    double getMaxDistance() {
        return 6.0;
    }

    double getRange() {
        return 7.0;
    }

    float getMotionVelocity(LivingEntity entity) {
        return Math.max(entity.func_70689_ay() / 2.0f, 0.05f);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getRange());
    }

    @Override
    public int getColor() {
        return 4946300;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }
}

