/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ForgeHooks;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.mana.BlockSpreader;
import vazkii.botania.common.core.handler.ModSounds;

public class SubTileEndoflame
extends TileEntityGeneratingFlower {
    private static final String TAG_BURN_TIME = "burnTime";
    private static final int FUEL_CAP = 32000;
    private static final int RANGE = 3;
    private static final int START_BURN_EVENT = 0;
    private int burnTime = 0;

    public SubTileEndoflame() {
        super(ModSubtiles.ENDOFLAME);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (this.func_145831_w().field_72995_K) {
            if (this.burnTime > 0 && this.func_145831_w().field_73012_v.nextInt(10) == 0) {
                Vec3d offset = this.func_145831_w().func_180495_p(this.getEffectivePos()).func_191059_e((IBlockReader)this.func_145831_w(), this.getEffectivePos()).func_72441_c(0.4, 0.7, 0.4);
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)this.getEffectivePos().func_177958_n() + offset.field_72450_a + Math.random() * 0.2, (double)this.getEffectivePos().func_177956_o() + offset.field_72448_b, (double)this.getEffectivePos().func_177952_p() + offset.field_72449_c + Math.random() * 0.2, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (this.linkedCollector != null && this.burnTime == 0 && this.getMana() < this.getMaxMana()) {
            int slowdown = this.getSlowdownFactor();
            for (ItemEntity item : this.func_145831_w().func_217357_a(ItemEntity.class, new AxisAlignedBB(this.getEffectivePos().func_177982_a(-3, -3, -3), this.getEffectivePos().func_177982_a(4, 4, 4)))) {
                int burnTime;
                ItemStack stack;
                if (item.field_70292_b < 59 + slowdown || item.field_70128_L || (stack = item.func_92059_d()).func_190926_b() || stack.func_77973_b().hasContainerItem(stack) || (burnTime = this.getBurnTime(stack)) <= 0 || stack.func_190916_E() <= 0) continue;
                this.burnTime = Math.min(32000, burnTime) / 2;
                stack.func_190918_g(1);
                this.func_145831_w().func_184133_a(null, this.getEffectivePos(), ModSounds.endoflame, SoundCategory.BLOCKS, 0.2f, 1.0f);
                this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, item.func_145782_y());
                this.sync();
                return;
            }
        }
    }

    public boolean func_145842_c(int event, int param) {
        if (event == 0) {
            Entity e = this.func_145831_w().func_73045_a(param);
            if (e != null) {
                e.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, e.func_226277_ct_(), e.func_226278_cu_() + 0.1, e.func_226281_cx_(), 0.0, 0.0, 0.0);
                e.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        return super.func_145842_c(event, param);
    }

    @Override
    public int getMaxMana() {
        return 300;
    }

    @Override
    public int getValueForPassiveGeneration() {
        return 3;
    }

    @Override
    public int getColor() {
        return 7884800;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 3);
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_BURN_TIME, this.burnTime);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.func_74762_e(TAG_BURN_TIME);
    }

    @Override
    public boolean canGeneratePassively() {
        return this.burnTime > 0;
    }

    @Override
    public int getDelayBetweenPassiveGeneration() {
        return 2;
    }

    private int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b() || Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockSpreader) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)stack);
    }
}

