/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileGourmaryllis
extends TileEntityGeneratingFlower {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_DIGESTING_MANA = "digestingMana";
    public static final String TAG_LAST_FOODS = "lastFoods";
    public static final String TAG_LAST_FOOD_COUNT = "lastFoodCount";
    public static final String TAG_STREAK_LENGTH = "streakLength";
    private static final int RANGE = 1;
    private static final double[] STREAK_MULTIPLIERS = new double[]{0.0, 1.0, 1.3, 1.5, 1.6, 1.7, 1.75, 1.8};
    private int cooldown = 0;
    private int digestingMana = 0;
    private List<ItemStack> lastFoods = new LinkedList<ItemStack>();
    private int streakLength = -1;
    private int lastFoodCount = 0;

    public SubTileGourmaryllis() {
        super(ModSubtiles.GOURMARYLLIS);
    }

    private int getMaxStreak() {
        return STREAK_MULTIPLIERS.length - 1;
    }

    private double getMultiplierForStreak(int index) {
        if (index == 0) {
            return 1.0 / (double)(++this.lastFoodCount);
        }
        this.lastFoodCount = 1;
        return STREAK_MULTIPLIERS[index];
    }

    private int processFood(ItemStack food) {
        ListIterator<ItemStack> it = this.lastFoods.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            ItemStack streakFood = it.next();
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)streakFood, (ItemStack)food)) continue;
            it.remove();
            this.lastFoods.add(0, streakFood);
            return index;
        }
        ItemStack newestFood = food.func_77946_l();
        newestFood.func_190920_e(1);
        this.lastFoods.add(0, newestFood);
        if (this.lastFoods.size() >= this.getMaxStreak()) {
            this.lastFoods.remove(this.lastFoods.size() - 1);
        }
        return this.getMaxStreak();
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.cooldown > -1) {
            --this.cooldown;
        }
        if (this.digestingMana != 0) {
            int munchInterval = 2 + 2 * this.lastFoodCount;
            if (this.cooldown == 0) {
                this.addMana(this.digestingMana);
                this.digestingMana = 0;
                float burpPitch = (float)Math.pow(2.0, (double)(this.streakLength == 0 ? -this.lastFoodCount : this.streakLength) / 12.0);
                this.func_145831_w().func_184133_a(null, this.getEffectivePos(), SoundEvents.field_187739_dZ, SoundCategory.BLOCKS, 1.0f, burpPitch);
                this.sync();
            } else if (this.cooldown % munchInterval == 0) {
                this.func_145831_w().func_184133_a(null, this.getEffectivePos(), SoundEvents.field_187537_bA, SoundCategory.BLOCKS, 0.5f, 1.0f);
                Vec3d offset = this.func_145831_w().func_180495_p(this.getEffectivePos()).func_191059_e((IBlockReader)this.func_145831_w(), this.getEffectivePos()).func_72441_c(0.4, 0.6, 0.4);
                ((ServerWorld)this.func_145831_w()).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.lastFoods.get(0)), (double)this.getEffectivePos().func_177958_n() + offset.field_72450_a, (double)this.getEffectivePos().func_177956_o() + offset.field_72448_b, (double)this.getEffectivePos().func_177952_p() + offset.field_72449_c, 10, 0.1, 0.1, 0.1, 0.03);
            }
        }
        int slowdown = this.getSlowdownFactor();
        List items = this.func_145831_w().func_217357_a(ItemEntity.class, new AxisAlignedBB(this.getEffectivePos().func_177982_a(-1, -1, -1), this.getEffectivePos().func_177982_a(2, 2, 2)));
        for (ItemEntity item : items) {
            ItemStack stack = item.func_92059_d();
            if (stack.func_190926_b() || !stack.func_77973_b().func_219971_r() || item.field_70128_L || item.field_70292_b < slowdown) continue;
            if (this.cooldown <= 0) {
                this.streakLength = Math.min(this.streakLength + 1, this.processFood(stack));
                int val = Math.min(12, stack.func_77973_b().func_219967_s().func_221466_a());
                this.digestingMana = val * val * 70;
                this.digestingMana = (int)((double)this.digestingMana * this.getMultiplierForStreak(this.streakLength));
                this.cooldown = val * 10;
                item.func_184185_a(SoundEvents.field_187537_bA, 0.2f, 0.6f);
                this.sync();
                ((ServerWorld)this.func_145831_w()).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), 20, 0.1, 0.1, 0.1, 0.05);
            }
            item.func_70106_y();
        }
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
        cmp.func_74768_a(TAG_DIGESTING_MANA, this.digestingMana);
        ListNBT foodList = new ListNBT();
        for (ItemStack food : this.lastFoods) {
            foodList.add((Object)food.func_77955_b(new CompoundNBT()));
        }
        cmp.func_218657_a(TAG_LAST_FOODS, (INBT)foodList);
        cmp.func_74768_a(TAG_LAST_FOOD_COUNT, this.lastFoodCount);
        cmp.func_74768_a(TAG_STREAK_LENGTH, this.streakLength);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
        this.digestingMana = cmp.func_74762_e(TAG_DIGESTING_MANA);
        this.lastFoods.clear();
        ListNBT foodList = cmp.func_150295_c(TAG_LAST_FOODS, 10);
        for (int i = 0; i < foodList.size(); ++i) {
            this.lastFoods.add(ItemStack.func_199557_a((CompoundNBT)foodList.func_150305_b(i)));
        }
        this.lastFoodCount = cmp.func_74762_e(TAG_LAST_FOOD_COUNT);
        this.streakLength = cmp.func_74762_e(TAG_STREAK_LENGTH);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 9000;
    }

    @Override
    public int getColor() {
        return 13882884;
    }
}

