/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class TileBrewery
extends TileSimpleInventory
implements IManaReceiver,
ITickableTileEntity {
    private static final String TAG_MANA = "mana";
    private static final int CRAFT_EFFECT_EVENT = 0;
    public IBrewRecipe recipe;
    private int mana = 0;
    private int manaLastTick = 0;
    public int signal = 0;

    public TileBrewery() {
        super(ModTiles.BREWERY);
    }

    public boolean addItem(@Nullable PlayerEntity player, ItemStack stack, @Nullable Hand hand) {
        if (this.recipe != null || stack.func_190926_b() || stack.func_77973_b() instanceof IBrewItem && ((IBrewItem)stack.func_77973_b()).getBrew(stack) != null && ((IBrewItem)stack.func_77973_b()).getBrew(stack) != ModBrews.fallbackBrew || this.itemHandler.getStackInSlot(0).func_190926_b() != stack.func_77973_b() instanceof IBrewContainer) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            did = true;
            ItemStack stackToAdd = stack.func_77946_l();
            stackToAdd.func_190920_e(1);
            this.itemHandler.setStackInSlot(i, stackToAdd);
            if (player != null && player.field_71075_bZ.field_75098_d) break;
            stack.func_190918_g(1);
            if (!stack.func_190926_b() || player == null) break;
            player.func_184611_a(hand, ItemStack.field_190927_a);
            break;
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            this.findRecipe();
        }
        return true;
    }

    private void findRecipe() {
        Optional maybeRecipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.BREW_TYPE, (IInventory)this.getRecipeWrapper(), this.field_145850_b);
        maybeRecipe.ifPresent(recipeBrew -> {
            this.recipe = recipeBrew;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)ModBlocks.brewery.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
        });
    }

    public void func_73660_a() {
        if (this.mana > 0 && this.recipe == null) {
            this.findRecipe();
            if (this.recipe == null) {
                this.mana = 0;
            }
        }
        this.receiveMana(0);
        if (!this.field_145850_b.field_72995_K && this.recipe == null) {
            List items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)));
            for (ItemEntity item : items) {
                if (!item.func_70089_S() || item.func_92059_d().func_190926_b()) continue;
                ItemStack stack = item.func_92059_d();
                this.addItem(null, stack, null);
            }
        }
        if (this.recipe != null) {
            if (!this.recipe.func_77569_a((IInventory)this.getRecipeWrapper(), this.field_145850_b)) {
                this.recipe = null;
                this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.brewery.func_176223_P());
            }
            if (this.recipe != null) {
                if (this.mana != this.manaLastTick) {
                    int color = this.recipe.getBrew().getColor(this.itemHandler.getStackInSlot(0));
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    for (int i = 0; i < 5; ++i) {
                        WispParticleData data1 = WispParticleData.wisp(0.1f + (float)Math.random() * 0.05f, r, g, b);
                        this.field_145850_b.func_195594_a((IParticleData)data1, (double)this.field_174879_c.func_177958_n() + 0.7 - Math.random() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.9 - Math.random() * 0.2, (double)this.field_174879_c.func_177952_p() + 0.7 - Math.random() * 0.4, (double)(0.03f - (float)Math.random() * 0.06f), (double)(0.03f + (float)Math.random() * 0.015f), (double)(0.03f - (float)Math.random() * 0.06f));
                        for (int j = 0; j < 2; ++j) {
                            WispParticleData data = WispParticleData.wisp(0.1f + (float)Math.random() * 0.2f, 0.2f, 0.2f, 0.2f);
                            this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.7 - Math.random() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.9 - Math.random() * 0.2, (double)this.field_174879_c.func_177952_p() + 0.7 - Math.random() * 0.4, (double)(0.03f - (float)Math.random() * 0.06f), (double)(0.03f + (float)Math.random() * 0.015f), (double)(0.03f - (float)Math.random() * 0.06f));
                        }
                    }
                }
                if (this.mana >= this.getManaCost() && !this.field_145850_b.field_72995_K) {
                    int mana = this.getManaCost();
                    this.receiveMana(-mana);
                    ItemStack output = this.recipe.getOutput(this.itemHandler.getStackInSlot(0));
                    ItemEntity outputItem = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                    this.field_145850_b.func_217376_c((Entity)outputItem);
                    this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.brewery, 0, this.recipe.getBrew().getColor(output));
                    for (int i = 0; i < this.getSizeInventory(); ++i) {
                        this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
            }
        }
        int newSignal = 0;
        if (this.recipe != null) {
            ++newSignal;
        }
        if (newSignal != this.signal) {
            this.signal = newSignal;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
        this.manaLastTick = this.mana;
    }

    public boolean func_145842_c(int event, int param) {
        if (event == 0) {
            if (this.field_145850_b.field_72995_K) {
                for (int i = 0; i < 25; ++i) {
                    float r = (float)(param >> 16 & 0xFF) / 255.0f;
                    float g = (float)(param >> 8 & 0xFF) / 255.0f;
                    float b = (float)(param & 0xFF) / 255.0f;
                    SparkleParticleData data1 = SparkleParticleData.sparkle((float)Math.random() * 2.0f + 0.5f, r, g, b, 10);
                    this.field_145850_b.func_195594_a((IParticleData)data1, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    for (int j = 0; j < 2; ++j) {
                        WispParticleData data = WispParticleData.wisp(0.1f + (float)Math.random() * 0.2f, 0.2f, 0.2f, 0.2f);
                        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.7 - Math.random() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.9 - Math.random() * 0.2, (double)this.field_174879_c.func_177952_p() + 0.7 - Math.random() * 0.4, (double)(0.05f - (float)Math.random() * 0.1f), (double)(0.05f + (float)Math.random() * 0.03f), (double)(0.05f - (float)Math.random() * 0.1f));
                    }
                }
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.potionCreate, SoundCategory.BLOCKS, 1.0f, 1.5f + (float)Math.random() * 0.25f, false);
            }
            return true;
        }
        return super.func_145842_c(event, param);
    }

    public int getManaCost() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (this.recipe == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof IBrewContainer)) {
            return 0;
        }
        IBrewContainer container = (IBrewContainer)stack.func_77973_b();
        return container.getManaCost(this.recipe.getBrew(), stack);
    }

    @Override
    public void writePacketNBT(CompoundNBT tag) {
        super.writePacketNBT(tag);
        tag.func_74768_a(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(CompoundNBT tag) {
        super.readPacketNBT(tag);
        this.mana = tag.func_74762_e(TAG_MANA);
    }

    @Override
    public int getSizeInventory() {
        return 7;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, false){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.getManaCost();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.getManaCost());
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }

    public void renderHUD(Minecraft mc) {
        int manaToGet = this.getManaCost();
        if (manaToGet > 0) {
            int x = mc.func_228018_at_().func_198107_o() / 2 + 20;
            int y = mc.func_228018_at_().func_198087_p() / 2 - 8;
            if (this.recipe == null) {
                return;
            }
            RenderHelper.renderProgressPie(x, y, (float)this.mana / (float)manaToGet, this.recipe.getOutput(this.itemHandler.getStackInSlot(0)));
        }
    }
}

