/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.loot;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AddRandomItemModifier
extends LootModifier {
    private final List<ItemStack> items;

    protected AddRandomItemModifier(ILootCondition[] conditionsIn, List<ItemStack> items) {
        super(conditionsIn);
        this.items = items;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack stack = this.items.get(context.func_216032_b().nextInt(this.items.size()));
        generatedLoot.add(stack.func_77946_l());
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddRandomItemModifier> {
        public AddRandomItemModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            JsonArray items = JSONUtils.func_151214_t((JsonObject)object, (String)"items");
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement item : items) {
                builder.add((Object)CraftingHelper.getItemStack((JsonObject)item.getAsJsonObject(), (boolean)true));
            }
            return new AddRandomItemModifier(ailootcondition, (List<ItemStack>)builder.build());
        }
    }
}

