/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.entity.ModEntities;

public class EntitySignalFlare
extends Entity {
    private static final String COLOR_TAG = "color";
    private static final String FIRED_Y_TAG = "firedY";
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntitySignalFlare.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FIRED_Y = EntityDataManager.func_187226_a(EntitySignalFlare.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntitySignalFlare(EntityType<EntitySignalFlare> type, World world) {
        super(type, world);
    }

    public EntitySignalFlare(World world) {
        this(ModEntities.SIGNAL_FLARE, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(FIRED_Y, (Object)0);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70173_aa++ >= 100) {
            this.func_70106_y();
        }
        if (!this.field_70128_L) {
            int color;
            if (this.field_70173_aa % 10 == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 1.0f);
            }
            if ((color = this.getColor()) < 16 && color >= 0) {
                WispParticleData data;
                int i;
                int hex = DyeColor.func_196056_a((int)color).field_193351_w;
                int r = (hex & 0xFF0000) >> 16;
                int g = (hex & 0xFF00) >> 8;
                int b = hex & 0xFF;
                for (i = 0; i < 3; ++i) {
                    data = WispParticleData.wisp((float)Math.random() * 5.0f + 1.0f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                    Botania.proxy.addParticleForce(this.field_70170_p, data, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_() + 0.5, (float)(Math.random() - 0.5), 10.0f * (float)Math.sqrt(256.0f / (256.0f - (float)this.func_226278_cu_())), (float)(Math.random() - 0.5));
                }
                for (i = 0; i < 4; ++i) {
                    data = WispParticleData.wisp((float)Math.random() * 15.0f + 8.0f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                    Botania.proxy.addParticleForce(this.field_70170_p, data, this.func_226277_ct_() + 0.5, Math.min(256, this.getFiredAt() + Botania.proxy.getClientRenderDistance() * 16), this.func_226281_cx_() + 0.5, (float)(Math.random() - 0.5) * 8.0f, 0.0, (float)(Math.random() - 0.5) * 8.0f);
                }
            }
        }
    }

    protected void func_70037_a(@Nonnull CompoundNBT nbttagcompound) {
        this.setColor(nbttagcompound.func_74762_e(COLOR_TAG));
        this.setFiredAt(nbttagcompound.func_74762_e(FIRED_Y_TAG));
    }

    protected void func_213281_b(@Nonnull CompoundNBT nbttagcompound) {
        nbttagcompound.func_74768_a(COLOR_TAG, this.getColor());
        nbttagcompound.func_74768_a(FIRED_Y_TAG, this.getFiredAt());
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setFiredAt(int y) {
        this.field_70180_af.func_187227_b(FIRED_Y, (Object)y);
    }

    public int getFiredAt() {
        return (Integer)this.field_70180_af.func_187225_a(FIRED_Y);
    }
}

