/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.VineBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityVineBall
extends ThrowableEntity
implements IRendersAsItem {
    private static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntityVineBall.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final Map<Direction, BooleanProperty> propMap = ImmutableMap.of((Object)Direction.NORTH, (Object)VineBlock.field_176273_b, (Object)Direction.SOUTH, (Object)VineBlock.field_176279_N, (Object)Direction.WEST, (Object)VineBlock.field_176280_O, (Object)Direction.EAST, (Object)VineBlock.field_176278_M);

    public EntityVineBall(EntityType<EntityVineBall> type, World world) {
        super(type, world);
    }

    public EntityVineBall(LivingEntity thrower, boolean gravity) {
        super(ModEntities.VINE_BALL, thrower, thrower.field_70170_p);
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity ? 0.03f : 0.0f));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(GRAVITY, (Object)Float.valueOf(0.0f));
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int j = 0; j < 16; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)ModItems.vineBall)), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), Math.random() * 0.2 - 0.1, Math.random() * 0.25, Math.random() * 0.2 - 0.1);
            }
        }
    }

    protected void func_70184_a(@Nonnull RayTraceResult rtr) {
        if (!this.field_70170_p.field_72995_K) {
            Direction dir;
            if (rtr.func_216346_c() == RayTraceResult.Type.BLOCK && (dir = ((BlockRayTraceResult)rtr).func_216354_b()).func_176740_k() != Direction.Axis.Y) {
                BlockState state;
                Block block;
                BlockPos pos = ((BlockRayTraceResult)rtr).func_216350_a().func_177972_a(dir);
                boolean first = true;
                while (pos.func_177956_o() > 0 && (block = (state = this.field_70170_p.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockReader)this.field_70170_p, pos)) {
                    BlockState stateSet = (BlockState)ModBlocks.solidVines.func_176223_P().func_206870_a((IProperty)propMap.get(dir.func_176734_d()), (Comparable)Boolean.valueOf(true));
                    if (first && !stateSet.func_196955_c((IWorldReader)this.field_70170_p, pos)) break;
                    first = false;
                    this.field_70170_p.func_175656_a(pos, stateSet);
                    this.field_70170_p.func_217379_c(2001, pos, Block.func_196246_j((BlockState)stateSet));
                    pos = pos.func_177977_b();
                }
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
    }

    @Nonnull
    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ModItems.vineBall);
    }
}

