/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IRegistryDelegate;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.internal.IInternalMethodHandler;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.core.handler.InternalMethodHandler;
import vazkii.botania.common.core.handler.PixieHandler;
import vazkii.botania.common.item.ModItems;

public class BotaniaAPIImpl
implements BotaniaAPI {
    private static final LazyValue<Rarity> RELIC_RARITY = new LazyValue(() -> Rarity.create((String)"RELIC", (TextFormatting)TextFormatting.GOLD));
    private final InternalMethodHandler tmp = new InternalMethodHandler();
    public Map<ResourceLocation, Integer> oreWeights = Collections.emptyMap();
    public Map<ResourceLocation, Integer> netherOreWeights = Collections.emptyMap();
    private final Map<IRegistryDelegate<Block>, Function<DyeColor, Block>> paintableBlocks = new ConcurrentHashMap<IRegistryDelegate<Block>, Function<DyeColor, Block>>();

    @Override
    public int apiVersion() {
        return 1;
    }

    @Override
    public IForgeRegistry<Brew> getBrewRegistry() {
        return ModBrews.registry;
    }

    @Override
    public IArmorMaterial getManasteelArmorMaterial() {
        return ArmorMaterial.MANASTEEL;
    }

    @Override
    public IArmorMaterial getElementiumArmorMaterial() {
        return ArmorMaterial.ELEMENTIUM;
    }

    @Override
    public IArmorMaterial getManaweaveArmorMaterial() {
        return ArmorMaterial.MANAWEAVE;
    }

    @Override
    public IArmorMaterial getTerrasteelArmorMaterial() {
        return ArmorMaterial.TERRASTEEL;
    }

    @Override
    public IItemTier getManasteelItemTier() {
        return ItemTier.MANASTEEL;
    }

    @Override
    public IItemTier getElementiumItemTier() {
        return ItemTier.ELEMENTIUM;
    }

    @Override
    public IItemTier getTerrasteelItemTier() {
        return ItemTier.TERRASTEEL;
    }

    @Override
    public Rarity getRelicRarity() {
        return (Rarity)RELIC_RARITY.func_179281_c();
    }

    @Override
    public IInternalMethodHandler internalHandler() {
        return this.tmp;
    }

    @Override
    public IAttribute getPixieSpawnChanceAttribute() {
        return PixieHandler.PIXIE_SPAWN_CHANCE;
    }

    @Override
    public Map<ResourceLocation, Integer> getOreWeights() {
        return Collections.unmodifiableMap(this.oreWeights);
    }

    @Override
    public Map<ResourceLocation, Integer> getNetherOreWeights() {
        return Collections.unmodifiableMap(this.netherOreWeights);
    }

    @Override
    public Map<IRegistryDelegate<Block>, Function<DyeColor, Block>> getPaintableBlocks() {
        return Collections.unmodifiableMap(this.paintableBlocks);
    }

    @Override
    public void registerPaintableBlock(IRegistryDelegate<Block> block, Function<DyeColor, Block> transformer) {
        this.paintableBlocks.put(block, transformer);
    }

    private static enum ItemTier implements IItemTier
    {
        MANASTEEL(300, 6.2f, 2.0f, 3, 20, () -> ModItems.manaSteel),
        ELEMENTIUM(720, 6.2f, 2.0f, 3, 20, () -> ModItems.elementium),
        TERRASTEEL(2300, 9.0f, 3.0f, 4, 26, () -> ModItems.terrasteel);

        private final int maxUses;
        private final float efficiency;
        private final float attackDamage;
        private final int harvestLevel;
        private final int enchantability;
        private final Supplier<Item> repairItem;

        private ItemTier(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Supplier<Item> repairItem) {
            this.maxUses = maxUses;
            this.efficiency = efficiency;
            this.attackDamage = attackDamage;
            this.harvestLevel = harvestLevel;
            this.enchantability = enchantability;
            this.repairItem = repairItem;
        }

        public int func_200926_a() {
            return this.maxUses;
        }

        public float func_200928_b() {
            return this.efficiency;
        }

        public float func_200929_c() {
            return this.attackDamage;
        }

        public int func_200925_d() {
            return this.harvestLevel;
        }

        public int func_200927_e() {
            return this.enchantability;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)this.repairItem.get()});
        }
    }

    private static enum ArmorMaterial implements IArmorMaterial
    {
        MANASTEEL("manasteel", 16, new int[]{2, 5, 6, 2}, 18, () -> SoundEvents.field_187725_r, () -> ModItems.manaSteel, 0.0f),
        MANAWEAVE("manaweave", 5, new int[]{1, 2, 2, 1}, 18, () -> SoundEvents.field_187728_s, () -> ModItems.manaweaveCloth, 0.0f),
        ELEMENTIUM("elementium", 18, new int[]{2, 5, 6, 2}, 18, () -> SoundEvents.field_187725_r, () -> ModItems.elementium, 0.0f),
        TERRASTEEL("terrasteel", 34, new int[]{3, 6, 8, 3}, 26, () -> SoundEvents.field_187716_o, () -> ModItems.terrasteel, 3.0f);

        private final String name;
        private final int durabilityMultiplier;
        private final int[] damageReduction;
        private final int enchantability;
        private final Supplier<SoundEvent> equipSound;
        private final Supplier<Item> repairItem;
        private final float toughness;
        private static final int[] MAX_DAMAGE_ARRAY;

        private ArmorMaterial(String name, int durabilityMultiplier, int[] damageReduction, int enchantability, Supplier<SoundEvent> equipSound, Supplier<Item> repairItem, float toughness) {
            this.name = name;
            this.durabilityMultiplier = durabilityMultiplier;
            this.damageReduction = damageReduction;
            this.enchantability = enchantability;
            this.equipSound = equipSound;
            this.repairItem = repairItem;
            this.toughness = toughness;
        }

        public int func_200896_a(EquipmentSlotType slot) {
            return this.durabilityMultiplier * MAX_DAMAGE_ARRAY[slot.func_188454_b()];
        }

        public int func_200902_b(EquipmentSlotType slot) {
            return this.damageReduction[slot.func_188454_b()];
        }

        public int func_200900_a() {
            return this.enchantability;
        }

        @Nonnull
        public SoundEvent func_200899_b() {
            return this.equipSound.get();
        }

        @Nonnull
        public Ingredient func_200898_c() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)this.repairItem.get()});
        }

        @Nonnull
        public String func_200897_d() {
            return this.name;
        }

        public float func_200901_e() {
            return this.toughness;
        }

        static {
            MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
        }
    }
}

