/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.client.core.handler.BaubleRenderHandler;
import vazkii.botania.client.core.handler.TooltipHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;

public abstract class ItemBauble
extends Item
implements ICosmeticAttachable,
IPhantomInkable {
    private static final String TAG_BAUBLE_UUID_MOST = "baubleUUIDMost";
    private static final String TAG_BAUBLE_UUID_LEAST = "baubleUUIDLeast";
    private static final String TAG_COSMETIC_ITEM = "cosmeticItem";
    private static final String TAG_PHANTOM_INK = "phantomInk";

    public ItemBauble(Item.Properties props) {
        super(props);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        TooltipHandler.addOnShift(tooltip, () -> this.addHiddenTooltip(stack, world, tooltip, flags));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        KeybindTextComponent key = new KeybindTextComponent("key.curios.open.desc");
        tooltip.add((ITextComponent)new TranslationTextComponent("botania.baubletooltip", new Object[]{key}));
        ItemStack cosmetic = this.getCosmeticItem(stack);
        if (!cosmetic.func_190926_b()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("botaniamisc.hasCosmetic", new Object[]{cosmetic.func_200301_q()}));
        }
        if (this.hasPhantomInk(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("botaniamisc.hasPhantomInk", new Object[0]));
        }
    }

    @Override
    public ItemStack getCosmeticItem(ItemStack stack) {
        CompoundNBT cmp = ItemNBTHelper.getCompound(stack, TAG_COSMETIC_ITEM, true);
        if (cmp == null) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)cmp);
    }

    @Override
    public void setCosmeticItem(ItemStack stack, ItemStack cosmetic) {
        CompoundNBT cmp = new CompoundNBT();
        if (!cosmetic.func_190926_b()) {
            cmp = cosmetic.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_COSMETIC_ITEM, cmp);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getContainerItem(stack).func_190926_b();
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return this.getCosmeticItem(itemStack);
    }

    public static UUID getBaubleUUID(ItemStack stack) {
        long most = ItemNBTHelper.getLong(stack, TAG_BAUBLE_UUID_MOST, 0L);
        if (most == 0L) {
            UUID uuid = UUID.randomUUID();
            ItemNBTHelper.setLong(stack, TAG_BAUBLE_UUID_MOST, uuid.getMostSignificantBits());
            ItemNBTHelper.setLong(stack, TAG_BAUBLE_UUID_LEAST, uuid.getLeastSignificantBits());
            return ItemBauble.getBaubleUUID(stack);
        }
        long least = ItemNBTHelper.getLong(stack, TAG_BAUBLE_UUID_LEAST, 0L);
        return new UUID(most, least);
    }

    @Override
    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return EquipmentHandler.initBaubleCap(stack);
    }

    public void onWornTick(ItemStack stack, LivingEntity entity) {
    }

    public void onEquipped(ItemStack stack, LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof ServerPlayerEntity) {
            PlayerHelper.grantCriterion((ServerPlayerEntity)entity, new ResourceLocation("botania", "main/bauble_wear"), "code_triggered");
        }
    }

    public void onUnequipped(ItemStack stack, LivingEntity entity) {
    }

    public boolean canEquip(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public Multimap<String, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        return HashMultimap.create();
    }

    public boolean hasRender(ItemStack stack, LivingEntity living) {
        return !(stack.func_77973_b() instanceof ICosmeticAttachable && !((ICosmeticAttachable)stack.func_77973_b()).getCosmeticItem(stack).func_190926_b() || stack.func_77973_b() instanceof IPhantomInkable && ((IPhantomInkable)stack.func_77973_b()).hasPhantomInk(stack) || (Boolean)ConfigHandler.CLIENT.renderAccessories.get() == false || living.func_70660_b(Effects.field_76441_p) != null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void doRender(BaubleRenderHandler layer, ItemStack stack, LivingEntity player, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

