/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.lib.ModTags;

public class ItemTerraformRod
extends Item
implements IManaUsingItem,
IBlockProvider {
    private static final int COST_PER = 55;
    private static final List<String> validBlocks = ImmutableList.of((Object)"hardenedClay", (Object)"snowLayer", (Object)"mycelium", (Object)"sandstone", (Object)"marble", (Object)"blockMarble", (Object)"limestone", (Object)"blockLimestone");

    public ItemTerraformRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        if (count != this.func_77626_a(stack) && count % 10 == 0 && living instanceof PlayerEntity) {
            this.terraform(stack, living.field_70170_p, (PlayerEntity)living);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    private void terraform(ItemStack stack, World world, PlayerEntity player) {
        int range = IManaProficiencyArmor.hasProficiency(player, stack) ? 22 : 16;
        BlockPos startCenter = new BlockPos((Entity)player).func_177977_b();
        if (startCenter.func_177956_o() < world.func_181545_F()) {
            return;
        }
        ArrayList<CoordsWithBlock> blocks = new ArrayList<CoordsWithBlock>();
        for (Object pos : BlockPos.func_218278_a((BlockPos)startCenter.func_177982_a(-range, -range, -range), (BlockPos)startCenter.func_177982_a(range, range, range))) {
            BlockState state = world.func_180495_p((BlockPos)pos);
            if (state.isAir((IBlockReader)world, (BlockPos)pos) || !ModTags.Blocks.TERRAFORMABLE.func_199685_a_((Object)state.func_177230_c())) continue;
            ArrayList<BlockPos> airBlocks = new ArrayList<BlockPos>();
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos pos_ = pos.func_177972_a(dir);
                BlockState state_ = world.func_180495_p(pos_);
                Block block_ = state_.func_177230_c();
                if (!state_.isAir((IBlockReader)world, pos_) && !state_.func_185904_a().func_76222_j() && (!(block_ instanceof FlowerBlock) || block_.func_203417_a(ModTags.Blocks.SPECIAL_FLOWERS)) && !(block_ instanceof DoublePlantBlock)) continue;
                airBlocks.add(pos_);
            }
            if (airBlocks.isEmpty()) continue;
            if (pos.func_177956_o() > startCenter.func_177956_o()) {
                blocks.add(new CoordsWithBlock((BlockPos)pos, Blocks.field_150350_a));
                continue;
            }
            for (BlockPos coords : airBlocks) {
                if (world.func_175623_d(coords.func_177977_b())) continue;
                blocks.add(new CoordsWithBlock(coords, Blocks.field_150346_d));
            }
        }
        int cost = 55 * blocks.size();
        if (world.field_72995_K || ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, true)) {
            if (!world.field_72995_K) {
                for (CoordsWithBlock block : blocks) {
                    world.func_175656_a((BlockPos)block, block.block.func_176223_P());
                }
            }
            if (!blocks.isEmpty()) {
                for (int i = 0; i < 10; ++i) {
                    world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187755_eF, SoundCategory.BLOCKS, 1.0f, 0.4f);
                }
                SparkleParticleData data = SparkleParticleData.sparkle(2.0f, 0.35f, 0.2f, 0.05f, 5);
                for (int i = 0; i < 120; ++i) {
                    world.func_195594_a((IParticleData)data, (double)(startCenter.func_177958_n() - range) + (double)(range * 2) * Math.random(), (double)(startCenter.func_177956_o() + 2) + (Math.random() - 0.5) * 2.0, (double)(startCenter.func_177952_p() - range) + (double)(range * 2) * Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public boolean provideBlock(PlayerEntity player, ItemStack requestor, ItemStack stack, Block block, boolean doit) {
        if (block == Blocks.field_150346_d) {
            return !doit || ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, true);
        }
        return false;
    }

    @Override
    public int getBlockCount(PlayerEntity player, ItemStack requestor, ItemStack stack, Block block) {
        if (block == Blocks.field_150346_d) {
            return -1;
        }
        return 0;
    }

    private static class CoordsWithBlock
    extends BlockPos {
        private final Block block;

        private CoordsWithBlock(BlockPos pos, Block block) {
            super((Vec3i)pos);
            this.block = block;
        }
    }
}

