/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;
import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.string.BlockRedString;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BlockstateProvider
extends BlockStateProvider {
    public BlockstateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "botania", exFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Botania Blockstates";
    }

    protected void registerStatesAndModels() {
        Registry.field_212618_g.func_201756_e().filter(b -> "botania".equals(Registry.field_212618_g.func_177774_c(b).func_110624_b())).forEach(b -> {
            if (b == ModBlocks.craftCrate || b == ModBlocks.ghostRail || b == ModBlocks.solidVines) {
                return;
            }
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            if (name.contains("quartz") && b instanceof RotatedPillarBlock) {
                ModelFile.ExistingModelFile file = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
                this.getVariantBuilder((Block)b).partialState().with((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 90, 90, false)}).partialState().with((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file)}).partialState().with((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 90, 0, false)});
            } else if (b instanceof SlabBlock) {
                ModelFile.ExistingModelFile file = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
                ModelFile.ExistingModelFile fullFile = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name.substring(0, name.length() - "_slab".length())));
                this.getVariantBuilder((Block)b).partialState().with((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file)}).partialState().with((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 180, 0, true)}).partialState().with((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)fullFile)});
            } else if (b instanceof StairsBlock) {
                ModelFile.ExistingModelFile stair = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
                ModelFile.ExistingModelFile inner = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_inner"));
                ModelFile.ExistingModelFile outer = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_outer"));
                this.stairsBlock((StairsBlock)b, (ModelFile)stair, (ModelFile)inner, (ModelFile)outer);
            } else if (b instanceof WallBlock) {
                ModelFile.ExistingModelFile post = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_post"));
                ModelFile.ExistingModelFile side = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_side"));
                this.wallBlock((WallBlock)b, (ModelFile)post, (ModelFile)side);
            } else if (b instanceof FenceBlock) {
                ModelFile.ExistingModelFile post = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_post"));
                ModelFile.ExistingModelFile side = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_side"));
                this.fourWayBlock((FourWayBlock)((FenceBlock)b), (ModelFile)post, (ModelFile)side);
            } else if (b instanceof FenceGateBlock) {
                ModelFile.ExistingModelFile gate = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
                ModelFile.ExistingModelFile gateOpen = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_open"));
                ModelFile.ExistingModelFile wall = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_wall"));
                ModelFile.ExistingModelFile wallOpen = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_wall_open"));
                this.fenceGateBlock((FenceGateBlock)b, (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)wall, (ModelFile)wallOpen);
            } else if (b instanceof PaneBlock) {
                ModelFile.ExistingModelFile post = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_post"));
                ModelFile.ExistingModelFile side = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_side"));
                ModelFile.ExistingModelFile sideAlt = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_side_alt"));
                ModelFile.ExistingModelFile noSide = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_noside"));
                ModelFile.ExistingModelFile noSideAlt = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_noside_alt"));
                this.paneBlock((PaneBlock)b, (ModelFile)post, (ModelFile)side, (ModelFile)sideAlt, (ModelFile)noSide, (ModelFile)noSideAlt);
            } else if (b instanceof TallFlowerBlock) {
                ModelFile.ExistingModelFile bottom = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
                ModelFile.ExistingModelFile top = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_top"));
                this.getVariantBuilder((Block)b).partialState().with((IProperty)TallFlowerBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottom)}).partialState().with((IProperty)TallFlowerBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)top)});
            } else if (b instanceof BlockAltGrass) {
                ModelFile.ExistingModelFile model = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
                this.getVariantBuilder((Block)b).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model), new ConfiguredModel((ModelFile)model, 0, 90, false), new ConfiguredModel((ModelFile)model, 0, 180, false), new ConfiguredModel((ModelFile)model, 0, 270, false)});
            } else if (b == ModBlocks.gaiaHead || b == ModBlocks.gaiaHeadWall) {
                ModelFile.ExistingModelFile file = this.models().getExistingFile(new ResourceLocation("block/soul_sand"));
                this.getVariantBuilder((Block)b).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file)});
            } else if (b instanceof BlockPetalBlock) {
                ModelFile.ExistingModelFile file = this.models().getExistingFile(ResourceLocationHelper.prefix("block/petal_block"));
                this.getVariantBuilder((Block)b).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file)});
            } else if (b instanceof BlockRedString) {
                this.redStringBlock((Block)b);
            } else if (b == ModBlocks.elfGlass) {
                ConfiguredModel[] files = (ConfiguredModel[])IntStream.rangeClosed(0, 3).mapToObj(i -> this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_" + i))).map(ConfiguredModel::new).toArray(ConfiguredModel[]::new);
                this.getVariantBuilder((Block)b).partialState().setModels(files);
            } else if (b == ModBlocks.enderEye || b == ModBlocks.manaDetector) {
                ModelFile.ExistingModelFile offFile = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
                ModelFile.ExistingModelFile onFile = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_powered"));
                this.getVariantBuilder((Block)b).partialState().with((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)offFile)});
                this.getVariantBuilder((Block)b).partialState().with((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)onFile)});
            } else if (b == ModBlocks.tinyPotato || b == ModBlocks.felPumpkin || b == ModBlocks.pump) {
                ModelFile.ExistingModelFile file = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
                this.horizontalBlock((Block)b, (ModelFile)file);
            } else if (b == ModBlocks.incensePlate) {
                ModelFile.ExistingModelFile file = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
                this.horizontalBlock((Block)b, (ModelFile)file, 0);
            } else {
                this.simpleBlock((Block)b, (ModelFile)this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name)));
            }
        });
    }

    private void redStringBlock(Block b) {
        ModelFile.ExistingModelFile file = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + Registry.field_212618_g.func_177774_c((Object)b).func_110623_a()));
        this.getVariantBuilder(b).partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file)}).partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.SOUTH).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 0, 180, false)}).partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.WEST).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 0, 270, false)}).partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 0, 90, false)}).partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 90, 0, false)}).partialState().with((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.UP).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 270, 0, false)});
    }
}

