/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractCircuit;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.packets.IFloatReceiver;
import com.Da_Technomancer.essentials.packets.SendFloatToClient;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.TickPriority;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;

public class CircuitTileEntity
extends TileEntity
implements IFloatReceiver {
    @ObjectHolder(value="essentials:circuit")
    private static TileEntityType<CircuitTileEntity> TYPE = null;
    public boolean builtConnections = false;
    private final ArrayList<WeakReference<LazyOptional<IRedstoneHandler>>> dependents = new ArrayList(1);
    private final ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Orient>> sources = new ArrayList(4);
    private LazyOptional<IRedstoneHandler> hanOptional = LazyOptional.of(() -> new RedsHandler());
    private WeakReference<LazyOptional<IRedstoneHandler>> hanReference = new WeakReference<LazyOptional<IRedstoneHandler>>(this.hanOptional);
    private float output = 0.0f;

    public CircuitTileEntity() {
        this(TYPE);
    }

    protected CircuitTileEntity(TileEntityType<?> type) {
        super(type);
    }

    private AbstractCircuit getOwner() {
        Block b = this.func_195044_w().func_177230_c();
        if (b instanceof AbstractCircuit) {
            return (AbstractCircuit)b;
        }
        this.func_145843_s();
        return ESBlocks.consCircuit;
    }

    private Direction getFacing() {
        BlockState s = this.func_195044_w();
        if (s.func_196959_b((IProperty)ESProperties.HORIZ_FACING)) {
            return (Direction)s.func_177229_b((IProperty)ESProperties.HORIZ_FACING);
        }
        this.func_145843_s();
        return Direction.NORTH;
    }

    public float getOutput() {
        this.buildConnections();
        return this.output;
    }

    private void setPower(float newPower) {
        if (RedstoneUtil.didChange(this.output, newPower)) {
            Direction facing = this.getFacing();
            if (this.dependents.isEmpty() && RedstoneUtil.clampToVanilla(this.output) != RedstoneUtil.clampToVanilla(newPower)) {
                this.output = newPower;
                this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(facing), (Block)this.getOwner(), this.field_174879_c.func_177972_a(facing.func_176734_d()));
            }
            this.output = newPower;
            BlockUtil.sendClientPacketAround(this.field_145850_b, this.field_174879_c, new SendFloatToClient(0, this.output, this.field_174879_c));
            for (int i = 0; i < this.dependents.size(); ++i) {
                IRedstoneHandler handler;
                WeakReference<LazyOptional<IRedstoneHandler>> dependent = this.dependents.get(i);
                if (dependent == null || (handler = (IRedstoneHandler)BlockUtil.get((LazyOptional)dependent.get())) == null) {
                    this.dependents.remove(i);
                    --i;
                    continue;
                }
                handler.notifyInputChange(this.hanReference);
            }
            this.func_70296_d();
        }
    }

    public void recalculateOutput() {
        float newOutput;
        this.buildConnections();
        float[] inputs = new float[3];
        boolean[] hasSrc = new boolean[3];
        for (int i = 0; i < this.sources.size(); ++i) {
            IRedstoneHandler handl;
            WeakReference ref;
            Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Orient> src = this.sources.get(i);
            if (src == null || (ref = (WeakReference)src.getLeft()) == null || (handl = (IRedstoneHandler)BlockUtil.get((LazyOptional)ref.get())) == null) {
                this.sources.remove(i);
                --i;
                continue;
            }
            int ind = ((Orient)((Object)src.getRight())).ordinal();
            if (ind > 2) {
                IndexOutOfBoundsException e = new IndexOutOfBoundsException("Input into redstone device on the front! Pos: " + this.field_174879_c.toString() + "; Dim: " + this.field_145850_b.field_73011_w + "Type: " + this.getOwner().getRegistryName().toString());
                Essentials.logger.catching((Throwable)e);
                this.sources.remove(i);
                --i;
                continue;
            }
            inputs[ind] = Math.max(inputs[ind], RedstoneUtil.sanitize(handl.getOutput()));
            hasSrc[ind] = true;
        }
        Direction facing = this.getFacing();
        AbstractCircuit owner = this.getOwner();
        for (int i = 0; i < 3; ++i) {
            if (hasSrc[i] || !owner.useInput(Orient.values()[i])) continue;
            Direction dir = Orient.values()[i].getFacing(facing);
            inputs[i] = RedstoneUtil.getRedstoneOnSide(this.field_145850_b, this.field_174879_c, dir);
        }
        try {
            newOutput = owner.getOutput(inputs[0], inputs[1], inputs[2], this);
        }
        catch (ArithmeticException e) {
            newOutput = 0.0f;
        }
        this.setPower(RedstoneUtil.sanitize(newOutput));
    }

    public void buildConnections() {
        if (!this.builtConnections && !this.field_145850_b.field_72995_K) {
            IRedstoneHandler otherHandler;
            this.builtConnections = true;
            this.dependents.clear();
            this.sources.clear();
            AbstractCircuit own = this.getOwner();
            Direction dir = this.getFacing();
            for (Orient or : Orient.INPUTS) {
                IRedstoneHandler otherHandler2;
                Direction checkDir;
                TileEntity te;
                if (!own.useInput(or) || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(checkDir = or.getFacing(dir)))) == null || (otherHandler2 = (IRedstoneHandler)BlockUtil.get(te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, checkDir.func_176734_d()))) == null) continue;
                otherHandler2.requestSrc(this.hanReference, 0, checkDir.func_176734_d(), checkDir);
            }
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (te != null && (otherHandler = (IRedstoneHandler)BlockUtil.get(te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.func_176734_d()))) != null) {
                otherHandler.findDependents(this.hanReference, 0, dir.func_176734_d(), dir);
            }
            this.field_145850_b.func_205220_G_().func_205362_a(this.field_174879_c, (Object)own, 2, TickPriority.NORMAL);
        }
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.output = 0.0f;
        this.builtConnections = false;
        this.dependents.clear();
        this.sources.clear();
        this.hanOptional.invalidate();
        this.hanOptional = LazyOptional.of(() -> new RedsHandler());
        this.hanReference = new WeakReference<LazyOptional<IRedstoneHandler>>(this.hanOptional);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockUtil.sendClientPacketAround(this.field_145850_b, this.field_174879_c, new SendFloatToClient(0, this.output, this.field_174879_c));
            this.buildConnections();
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.hanOptional.invalidate();
    }

    @Override
    public void receiveFloat(byte id, float value, @Nullable ServerPlayerEntity sender) {
        if (id == 0 && this.field_145850_b.field_72995_K) {
            this.output = value;
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.output = nbt.func_74760_g("pow");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("pow", this.output);
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            Direction dir = this.getFacing();
            if (side == null || side.func_176740_k() != Direction.Axis.Y && (dir == side || this.getOwner().useInput(Orient.getOrient(side, dir)))) {
                return this.hanOptional;
            }
        }
        return super.getCapability(cap, side);
    }

    public static enum Orient {
        CCW,
        BACK,
        CW,
        FRONT;

        public static final Orient[] INPUTS;

        public static Orient getOrient(Direction dir, Direction front) {
            if (front != null) {
                if (front == dir) {
                    return FRONT;
                }
                if (front.func_176734_d() == dir) {
                    return BACK;
                }
                if (front.func_176746_e() == dir) {
                    return CW;
                }
                if (front.func_176735_f() == dir) {
                    return CCW;
                }
            }
            throw new IllegalArgumentException(String.format("front &/or dir are vertical/null. Front: %s; Dir: %s", front == null ? "NULL" : front.toString(), dir == null ? "NULL" : dir.toString()));
        }

        public Direction getFacing(Direction front) {
            switch (this) {
                case FRONT: {
                    return front;
                }
                case BACK: {
                    return front.func_176734_d();
                }
                case CW: {
                    return front.func_176746_e();
                }
                case CCW: {
                    return front.func_176735_f();
                }
            }
            throw new IllegalStateException("Unhandled Orientation: " + this.name());
        }

        static {
            INPUTS = new Orient[]{CCW, BACK, CW};
        }
    }

    private class RedsHandler
    implements IRedstoneHandler {
        private RedsHandler() {
        }

        @Override
        public float getOutput() {
            return CircuitTileEntity.this.output;
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
            LazyOptional srcOption = (LazyOptional)src.get();
            Orient or = Orient.getOrient(fromSide, CircuitTileEntity.this.getFacing());
            if (CircuitTileEntity.this.getOwner().useInput(or) && srcOption != null && srcOption.isPresent()) {
                IRedstoneHandler srcHandler = (IRedstoneHandler)BlockUtil.get(srcOption);
                srcHandler.addDependent(CircuitTileEntity.this.hanReference, nominalSide);
                Pair toAdd = Pair.of(src, (Object)((Object)or));
                if (!CircuitTileEntity.this.sources.contains(toAdd)) {
                    CircuitTileEntity.this.sources.add(toAdd);
                }
            }
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
            LazyOptional depenOption;
            if (Orient.getOrient(toSide, CircuitTileEntity.this.getFacing()) == Orient.FRONT && (depenOption = (LazyOptional)dependency.get()) != null && depenOption.isPresent()) {
                IRedstoneHandler depHandler = (IRedstoneHandler)BlockUtil.get(depenOption);
                depHandler.addSrc(CircuitTileEntity.this.hanReference, nominalSide);
                if (!CircuitTileEntity.this.dependents.contains(dependency)) {
                    CircuitTileEntity.this.dependents.add(dependency);
                }
            }
        }

        @Override
        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> src, Direction fromSide) {
            Orient or = Orient.getOrient(fromSide, CircuitTileEntity.this.getFacing());
            if (or != null && or != Orient.FRONT && CircuitTileEntity.this.getOwner().useInput(or)) {
                Pair toAdd = Pair.of(src, (Object)((Object)or));
                if (!CircuitTileEntity.this.sources.contains(toAdd)) {
                    CircuitTileEntity.this.sources.add(toAdd);
                    this.notifyInputChange(src);
                }
            }
        }

        @Override
        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> dependent, Direction toSide) {
            Orient or = Orient.getOrient(toSide, CircuitTileEntity.this.getFacing());
            if (or == Orient.FRONT && !CircuitTileEntity.this.dependents.contains(dependent)) {
                CircuitTileEntity.this.dependents.add(dependent);
            }
        }

        @Override
        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> src) {
            CircuitTileEntity.this.field_145850_b.func_205220_G_().func_205362_a(CircuitTileEntity.this.field_174879_c, (Object)CircuitTileEntity.this.getOwner(), 2, TickPriority.HIGH);
        }
    }
}

