/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.container.FluidShifterContainer;
import com.Da_Technomancer.essentials.gui.container.FluidSlotManager;
import com.Da_Technomancer.essentials.gui.container.IFluidSlotTE;
import com.Da_Technomancer.essentials.tileentities.AbstractShifterTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class FluidShifterTileEntity
extends AbstractShifterTileEntity
implements IFluidSlotTE {
    @ObjectHolder(value="fluid_shifter")
    private static TileEntityType<FluidShifterTileEntity> TYPE = null;
    private static final int CAPACITY = 4000;
    private FluidSlotManager fluidManager;
    private FluidStack fluid = FluidStack.EMPTY;
    private LazyOptional<IFluidHandler> invOptional = LazyOptional.of(() -> new FluidHandler());

    public FluidSlotManager getFluidManager() {
        if (this.fluidManager == null) {
            this.fluidManager = new FluidSlotManager(this.fluid, 4000);
        }
        return this.fluidManager;
    }

    public FluidShifterTileEntity() {
        super(TYPE);
    }

    public void func_73660_a() {
        FluidStack remaining;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.endPos == null) {
            this.refreshCache();
        }
        if ((remaining = AbstractShifterTileEntity.ejectFluid(this.field_145850_b, this.endPos, this.getFacing(), this.fluid)).getAmount() != this.fluid.getAmount()) {
            this.fluid = remaining;
            this.getFluidManager().updateState(this.fluid);
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a("fluid", (INBT)this.fluid.writeToNBT(new CompoundNBT()));
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("fluid"));
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invOptional.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.invOptional;
        }
        return super.getCapability(cap, facing);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.fluid_shifter", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new FluidShifterContainer(id, playerInventory, this.field_174879_c);
    }

    @Override
    public IFluidHandler getFluidHandler() {
        return (IFluidHandler)this.invOptional.orElseGet(() -> new FluidHandler());
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidShifterTileEntity.this.fluid;
        }

        public int getTankCapacity(int tank) {
            return 4000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if ((FluidShifterTileEntity.this.fluid.isEmpty() || BlockUtil.sameFluid(FluidShifterTileEntity.this.fluid, resource)) && !resource.isEmpty()) {
                int filled = Math.min(4000 - FluidShifterTileEntity.this.fluid.getAmount(), resource.getAmount());
                if (filled > 0 && action.execute()) {
                    if (FluidShifterTileEntity.this.fluid.isEmpty()) {
                        FluidShifterTileEntity.this.fluid = resource.copy();
                        FluidShifterTileEntity.this.fluid.setAmount(filled);
                    } else {
                        FluidShifterTileEntity.this.fluid.grow(filled);
                    }
                    FluidShifterTileEntity.this.func_70296_d();
                    FluidShifterTileEntity.this.getFluidManager().updateState(FluidShifterTileEntity.this.fluid);
                }
                return filled;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BlockUtil.sameFluid(FluidShifterTileEntity.this.fluid, resource)) {
                FluidStack drainFluid;
                int drained = Math.min(resource.getAmount(), FluidShifterTileEntity.this.fluid.getAmount());
                FluidStack fluidStack = drainFluid = drained == 0 ? FluidStack.EMPTY : FluidShifterTileEntity.this.fluid.copy();
                if (!drainFluid.isEmpty()) {
                    drainFluid.setAmount(drained);
                }
                if (drained > 0 && action.execute()) {
                    FluidShifterTileEntity.this.fluid.shrink(drained);
                    FluidShifterTileEntity.this.func_70296_d();
                    FluidShifterTileEntity.this.getFluidManager().updateState(FluidShifterTileEntity.this.fluid);
                }
                return drainFluid;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack drainFluid;
            int drained = Math.min(maxDrain, FluidShifterTileEntity.this.fluid.getAmount());
            FluidStack fluidStack = drainFluid = drained == 0 ? FluidStack.EMPTY : FluidShifterTileEntity.this.fluid.copy();
            if (!drainFluid.isEmpty()) {
                drainFluid.setAmount(drained);
            }
            if (drained > 0 && action.execute()) {
                FluidShifterTileEntity.this.fluid.shrink(drained);
                FluidShifterTileEntity.this.getFluidManager().updateState(FluidShifterTileEntity.this.fluid);
                FluidShifterTileEntity.this.func_70296_d();
            }
            return drainFluid;
        }
    }
}

