/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.SortingHopper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HopperContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class SortingHopperTileEntity
extends TileEntity
implements ITickableTileEntity,
IInventory,
INamedContainerProvider {
    @ObjectHolder(value="sorting_hopper")
    private static TileEntityType<SortingHopperTileEntity> TYPE = null;
    protected final ItemStack[] inventory = new ItemStack[5];
    private int transferCooldown = -1;
    private Direction dir = null;
    protected ItemHandler handler = new ItemHandler();

    protected SortingHopperTileEntity(TileEntityType<?> type) {
        super(type);
        for (int i = 0; i < 5; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    public SortingHopperTileEntity() {
        this(TYPE);
    }

    public void resetCache() {
        this.dir = null;
    }

    protected Direction getDir() {
        if (this.dir == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof SortingHopper)) {
                return Direction.DOWN;
            }
            this.dir = (Direction)state.func_177229_b((IProperty)SortingHopper.FACING);
        }
        return this.dir;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && --this.transferCooldown <= 0) {
            this.transferCooldown = 0;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof SortingHopper && ((Boolean)state.func_177229_b((IProperty)SortingHopper.ENABLED)).booleanValue()) {
                boolean flag = false;
                if (!this.isFull()) {
                    flag = this.transferItemsIn();
                }
                if (!this.func_191420_l()) {
                    boolean bl = flag = this.transferItemsOut() || flag;
                }
                if (flag) {
                    this.transferCooldown = 8;
                    this.func_70296_d();
                }
            }
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.transferCooldown = nbt.func_74762_e("trans_cooldown");
        for (int i = 0; i < 5; ++i) {
            CompoundNBT stackNBT = nbt.func_74775_l("inv_" + i);
            this.inventory[i] = ItemStack.func_199557_a((CompoundNBT)stackNBT);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < 5; ++i) {
            if (this.inventory[i].func_190926_b()) continue;
            CompoundNBT stackNBT = new CompoundNBT();
            this.inventory[i].func_77955_b(stackNBT);
            nbt.func_218657_a("inv_" + i, (INBT)stackNBT);
        }
        nbt.func_74768_a("trans_cooldown", this.transferCooldown);
        return nbt;
    }

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int index) {
        return index > 4 ? ItemStack.field_190927_a : this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index > 4 || this.inventory[index].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_70296_d();
        return this.inventory[index].func_77979_a(count);
    }

    public ItemStack func_70304_b(int index) {
        if (index > 4) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = this.inventory[index];
        this.inventory[index] = ItemStack.field_190927_a;
        this.func_70296_d();
        return copy;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index > 4) {
            return;
        }
        this.inventory[index] = stack;
        this.func_70296_d();
        if (!stack.func_190926_b() && stack.func_190916_E() > stack.func_77976_d()) {
            stack.func_190920_e(stack.func_77976_d());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index < 5;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected boolean isFull() {
        for (ItemStack itemstack : this.inventory) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    protected int transferQuantity() {
        return 1;
    }

    protected boolean transferItemsOut() {
        Direction facing = this.getDir();
        IItemHandler otherHandler = SortingHopperTileEntity.getHandlerAtPositon(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
        if (otherHandler != null) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.func_70301_a(i);
                if (stackInSlot.func_190926_b()) continue;
                ItemStack insert = stackInSlot.func_77946_l();
                insert.func_190920_e(Math.min(insert.func_190916_E(), this.transferQuantity()));
                ItemStack newStack = ItemHandlerHelper.insertItem((IItemHandler)otherHandler, (ItemStack)insert, (boolean)true);
                if (newStack.func_190916_E() >= insert.func_190916_E()) continue;
                ItemHandlerHelper.insertItem((IItemHandler)otherHandler, (ItemStack)this.func_70298_a(i, insert.func_190916_E() - newStack.func_190916_E()), (boolean)false);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    protected boolean transferItemsIn() {
        IItemHandler otherHandler = SortingHopperTileEntity.getHandlerAtPositon(this.field_145850_b, this.field_174879_c.func_177972_a(Direction.UP), Direction.DOWN);
        if (otherHandler != null) {
            for (int i = 0; i < otherHandler.getSlots(); ++i) {
                ItemStack extractItem = otherHandler.extractItem(i, this.transferQuantity(), true);
                if (extractItem.func_190926_b()) continue;
                for (int j = 0; j < this.func_70302_i_(); ++j) {
                    ItemStack uninserted = this.handler.insertItem(j, extractItem, false);
                    if (uninserted.func_190916_E() >= extractItem.func_190916_E()) continue;
                    otherHandler.extractItem(i, extractItem.func_190916_E() - uninserted.func_190916_E(), false);
                    return true;
                }
            }
            return false;
        }
        boolean changed = false;
        for (ItemEntity entityitem : this.field_145850_b.func_175647_a(ItemEntity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)this.field_174879_c.func_177956_o() + 2.0, (double)(this.field_174879_c.func_177952_p() + 1)), EntityPredicates.field_94557_a)) {
            ItemStack stack;
            if (entityitem == null) continue;
            ItemStack remain = stack = entityitem.func_92059_d().func_77946_l();
            for (int i = 0; i < 5 && !(remain = this.handler.insertItem(i, remain, false)).func_190926_b(); ++i) {
            }
            if (remain.func_190926_b()) {
                entityitem.func_70106_y();
                changed = true;
                continue;
            }
            if (remain.func_190916_E() == stack.func_190916_E()) continue;
            entityitem.func_92058_a(remain);
            changed = true;
        }
        return changed;
    }

    protected static IItemHandler getHandlerAtPositon(World world, BlockPos otherPos, Direction direction) {
        List list;
        LazyOptional capability;
        IItemHandler otherHandler = null;
        TileEntity tileEntity = world.func_175625_s(otherPos);
        if (tileEntity != null && (capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction)).isPresent()) {
            otherHandler = (IItemHandler)capability.orElseThrow(NullPointerException::new);
        }
        if (otherHandler == null && !(list = world.func_175674_a(null, new AxisAlignedBB(otherPos), EntityPredicates.field_96566_b)).isEmpty()) {
            otherHandler = new InvWrapper((IInventory)list.get(world.field_73012_v.nextInt(list.size())));
        }
        return otherHandler;
    }

    protected static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public void func_174888_l() {
        for (int i = 0; i < 5; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
        this.func_70296_d();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.handler);
        }
        return super.getCapability(capability, facing);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.sorting_hopper", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new HopperContainer(id, playerInventory, (IInventory)this);
    }

    protected class ItemHandler
    implements IItemHandler {
        protected ItemHandler() {
        }

        public int getSlots() {
            return SortingHopperTileEntity.this.func_70302_i_();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return SortingHopperTileEntity.this.func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b() || slot > 4) {
                return ItemStack.field_190927_a;
            }
            if (SortingHopperTileEntity.this.inventory[slot].func_190926_b() || SortingHopperTileEntity.canCombine(stack, SortingHopperTileEntity.this.inventory[slot])) {
                int moved = Math.min(stack.func_190916_E(), stack.func_77976_d() - SortingHopperTileEntity.this.inventory[slot].func_190916_E());
                ItemStack remain = stack.func_77946_l();
                remain.func_190918_g(moved);
                if (!simulate && moved != 0) {
                    if (SortingHopperTileEntity.this.inventory[slot].func_190926_b()) {
                        SortingHopperTileEntity.this.inventory[slot] = stack.func_77946_l();
                        SortingHopperTileEntity.this.inventory[slot].func_190920_e(moved);
                    } else {
                        SortingHopperTileEntity.this.inventory[slot].func_190917_f(moved);
                    }
                    if (SortingHopperTileEntity.this.transferCooldown < 1) {
                        SortingHopperTileEntity.this.transferCooldown = 8;
                    }
                    SortingHopperTileEntity.this.func_70296_d();
                }
                return remain;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            LazyOptional otherCap;
            if (amount <= 0 || slot > 4) {
                return ItemStack.field_190927_a;
            }
            Direction facing = SortingHopperTileEntity.this.getDir();
            TileEntity te = SortingHopperTileEntity.this.field_145850_b.func_175625_s(SortingHopperTileEntity.this.field_174879_c.func_177972_a(facing));
            if (te != null && (otherCap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())).isPresent()) {
                IItemHandler otherHandler = (IItemHandler)otherCap.orElseThrow(NullPointerException::new);
                int slots = otherHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    if (otherHandler.insertItem(i, SortingHopperTileEntity.this.inventory[slot], true).func_190916_E() >= SortingHopperTileEntity.this.inventory[slot].func_190916_E()) continue;
                    return ItemStack.field_190927_a;
                }
            }
            int removed = Math.min(amount, SortingHopperTileEntity.this.inventory[slot].func_190916_E());
            if (!simulate) {
                SortingHopperTileEntity.this.func_70296_d();
                return SortingHopperTileEntity.this.inventory[slot].func_77979_a(removed);
            }
            ItemStack out = SortingHopperTileEntity.this.inventory[slot].func_77946_l();
            out.func_190920_e(removed);
            return out;
        }

        public int getSlotLimit(int slot) {
            return SortingHopperTileEntity.this.func_70297_j_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

