/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RayTracer {
    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vec3d start, Vec3d end, BlockPos pos, List<IndexedCuboid6> cuboids) {
        return RayTracer.rayTraceCuboidsClosest(new Vector3(start), new Vector3(end), pos, cuboids);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, BlockPos pos, List<IndexedCuboid6> cuboids) {
        ArrayList<CuboidRayTraceResult> results = new ArrayList<CuboidRayTraceResult>();
        for (IndexedCuboid6 cuboid6 : cuboids) {
            CuboidRayTraceResult hit = RayTracer.rayTrace(pos, start, end, cuboid6);
            results.add(hit);
        }
        CuboidRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (CuboidRayTraceResult hit : results) {
            if (hit == null || !(curClosest > hit.dist)) continue;
            closestHit = hit;
            curClosest = hit.dist;
        }
        return closestHit;
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, BlockPos pos, AxisAlignedBB ... boxes) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (boxes != null) {
            for (AxisAlignedBB box : boxes) {
                cuboidList.add(new IndexedCuboid6((Object)0, box));
            }
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, pos, cuboidList);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vec3d start, Vec3d end, BlockPos pos, AxisAlignedBB ... boxes) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (boxes != null) {
            for (AxisAlignedBB box : boxes) {
                cuboidList.add(new IndexedCuboid6((Object)0, box));
            }
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, pos, cuboidList);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, BlockPos pos, Cuboid6 ... cuboids) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (cuboids != null) {
            for (Cuboid6 cuboid : cuboids) {
                cuboidList.add(new IndexedCuboid6((Object)0, cuboid));
            }
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, pos, cuboidList);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vec3d start, Vec3d end, BlockPos pos, Cuboid6 ... cuboids) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (cuboids != null) {
            for (Cuboid6 cuboid : cuboids) {
                cuboidList.add(new IndexedCuboid6((Object)0, cuboid));
            }
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, pos, cuboidList);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, BlockPos pos, IndexedCuboid6 ... cuboids) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (cuboids != null) {
            Collections.addAll(cuboidList, cuboids);
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, pos, cuboidList);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vec3d start, Vec3d end, BlockPos pos, IndexedCuboid6 ... cuboids) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (cuboids != null) {
            Collections.addAll(cuboidList, cuboids);
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, pos, cuboidList);
    }

    public static CuboidRayTraceResult rayTrace(BlockPos pos, Vector3 start, Vector3 end, IndexedCuboid6 cuboid) {
        BlockRayTraceResult bbResult = VoxelShapes.func_197881_a((AxisAlignedBB)cuboid.aabb()).func_212433_a(start.vec3(), end.vec3(), pos);
        if (bbResult != null) {
            Vector3 hitVec = new Vector3(bbResult.func_216347_e());
            Direction sideHit = bbResult.func_216354_b();
            double dist = hitVec.copy().subtract(start).magSquared();
            return new CuboidRayTraceResult(hitVec, sideHit, pos, bbResult.func_216353_d(), cuboid, dist);
        }
        return null;
    }

    public static BlockRayTraceResult retraceBlock(IBlockReader world, PlayerEntity player, BlockPos pos) {
        BlockRayTraceResult raytraceTraceShape;
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player);
        BlockState state = world.func_180495_p(pos);
        VoxelShape baseShape = state.func_196954_c(world, pos);
        BlockRayTraceResult baseTraceResult = baseShape.func_212433_a(startVec, endVec, pos);
        if (baseTraceResult != null && (raytraceTraceShape = state.func_199611_f(world, pos).func_212433_a(startVec, endVec, pos)) != null) {
            return raytraceTraceShape;
        }
        return baseTraceResult;
    }

    private static double getBlockReachDistance_server(ServerPlayerEntity player) {
        return player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    public static BlockRayTraceResult retrace(PlayerEntity player) {
        return RayTracer.retrace(player, RayTraceContext.BlockMode.OUTLINE);
    }

    public static BlockRayTraceResult retrace(PlayerEntity player, RayTraceContext.BlockMode blockMode) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player), blockMode, RayTraceContext.FluidMode.NONE);
    }

    public static BlockRayTraceResult retrace(PlayerEntity player, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player), blockMode, fluidMode);
    }

    public static BlockRayTraceResult retrace(PlayerEntity player, double reach, RayTraceContext.BlockMode blockMode) {
        return RayTracer.retrace(player, reach, blockMode, RayTraceContext.FluidMode.NONE);
    }

    public static BlockRayTraceResult retrace(PlayerEntity player, double reach, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player, reach);
        return player.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, blockMode, fluidMode, (Entity)player));
    }

    public static Vec3d getCorrectedHeadVec(PlayerEntity player) {
        Vector3 v = Vector3.fromEntity((Entity)player).add(0.0, player.func_70047_e(), 0.0);
        return v.vec3();
    }

    public static Vec3d getStartVec(PlayerEntity player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    @Deprecated
    public static double getBlockReachDistance(PlayerEntity player) {
        return player.field_70170_p.field_72995_K ? RayTracer.getBlockReachDistance_client() : (player instanceof ServerPlayerEntity ? RayTracer.getBlockReachDistance_server((ServerPlayerEntity)player) : 5.0);
    }

    public static Vec3d getEndVec(PlayerEntity player) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }

    public static Vec3d getEndVec(PlayerEntity player, double reach) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }
}

