/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.reflect;

import com.google.common.base.Objects;
import cpw.mods.modlauncher.api.INameMappingService;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraftforge.fml.loading.FMLLoader;
import org.objectweb.asm.commons.Remapper;

public class ObfMapping {
    public static Remapper remapper = new FMLRemapper();
    public String s_owner;
    public String s_name;
    public String s_desc;

    public ObfMapping(String owner) {
        this(owner, "", "");
    }

    public ObfMapping(String owner, String name) {
        this(owner, name, "");
    }

    public ObfMapping(String owner, String name, String desc) {
        this.s_owner = owner;
        this.s_name = name;
        this.s_desc = desc;
        if (this.s_owner.contains(".")) {
            throw new IllegalArgumentException(this.s_owner);
        }
    }

    public ObfMapping(ObfMapping descmap, String subclass) {
        this(subclass, descmap.s_name, descmap.s_desc);
    }

    public static ObfMapping fromDesc(String s) {
        int sep;
        int lastDot = s.lastIndexOf(46);
        if (lastDot < 0) {
            return new ObfMapping(s, "", "");
        }
        int sep_end = sep = s.indexOf(40);
        if (sep < 0) {
            sep = s.indexOf(32);
            sep_end = sep + 1;
        }
        if (sep < 0) {
            sep = s.indexOf(58);
            sep_end = sep + 1;
        }
        if (sep < 0) {
            return new ObfMapping(s.substring(0, lastDot), s.substring(lastDot + 1), "");
        }
        return new ObfMapping(s.substring(0, lastDot), s.substring(lastDot + 1, sep), s.substring(sep_end));
    }

    public ObfMapping subclass(String subclass) {
        return new ObfMapping(this, subclass);
    }

    public boolean isClass(String name) {
        return name.replace('.', '/').equals(this.s_owner);
    }

    public boolean matches(String name, String desc) {
        return this.s_name.equals(name) && this.s_desc.equals(desc);
    }

    public String javaClass() {
        return this.s_owner.replace('/', '.');
    }

    public String methodDesc() {
        return this.s_owner + "." + this.s_name + this.s_desc;
    }

    public String fieldDesc() {
        return this.s_owner + "." + this.s_name + ":" + this.s_desc;
    }

    public boolean isClass() {
        return this.s_name.length() == 0;
    }

    public boolean isMethod() {
        return this.s_desc.contains("(");
    }

    public boolean isField() {
        return !this.isClass() && !this.isMethod();
    }

    public ObfMapping map(Remapper mapper) {
        if (mapper == null) {
            return this;
        }
        if (this.isMethod()) {
            this.s_name = mapper.mapMethodName(this.s_owner, this.s_name, this.s_desc);
        } else if (this.isField()) {
            this.s_name = mapper.mapFieldName(this.s_owner, this.s_name, this.s_desc);
        }
        this.s_owner = mapper.mapType(this.s_owner);
        if (this.isMethod()) {
            this.s_desc = mapper.mapMethodDesc(this.s_desc);
        } else if (this.s_desc.length() > 0) {
            this.s_desc = mapper.mapDesc(this.s_desc);
        }
        return this;
    }

    public ObfMapping remap() {
        this.map(remapper);
        return this;
    }

    public ObfMapping copy() {
        return new ObfMapping(this.s_owner, this.s_name, this.s_desc);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObfMapping)) {
            return false;
        }
        ObfMapping desc = (ObfMapping)obj;
        return this.s_owner.equals(desc.s_owner) && this.s_name.equals(desc.s_name) && this.s_desc.equals(desc.s_desc);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.s_desc, this.s_name, this.s_owner});
    }

    public String toString() {
        if (this.s_name.length() == 0) {
            return "[" + this.s_owner + "]";
        }
        if (this.s_desc.length() == 0) {
            return "[" + this.s_owner + "." + this.s_name + "]";
        }
        return "[" + (this.isMethod() ? this.methodDesc() : this.fieldDesc()) + "]";
    }

    private static class FMLRemapper
    extends Remapper {
        private static Optional<BiFunction<INameMappingService.Domain, String, String>> nameFunction = FMLLoader.getNameFunction((String)"mcp");

        private FMLRemapper() {
        }

        public String mapMethodName(String owner, String name, String descriptor) {
            return nameFunction.map((? super T f) -> (String)f.apply(INameMappingService.Domain.METHOD, name)).orElse(name);
        }

        public String mapFieldName(String owner, String name, String descriptor) {
            return nameFunction.map((? super T f) -> (String)f.apply(INameMappingService.Domain.FIELD, name)).orElse(name);
        }

        public String map(String typeName) {
            return nameFunction.map((? super T f) -> (String)f.apply(INameMappingService.Domain.CLASS, typeName)).orElse(typeName);
        }
    }
}

