/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.AbstractShaderObject;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.Uniform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public class AssetShaderObject
extends AbstractShaderObject
implements ISelectiveResourceReloadListener {
    private final ResourceLocation asset;
    private String source;

    public AssetShaderObject(String name, ShaderObject.ShaderType type, Collection<Uniform> uniforms, ResourceLocation asset) {
        super(name, type, uniforms);
        this.asset = Objects.requireNonNull(asset);
    }

    @Override
    protected String getSource() {
        if (this.source == null) {
            try (IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(this.asset);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b()));){
                this.source = reader.lines().collect(Collectors.joining("\n"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.source;
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.source = null;
        this.dirty = true;
    }
}

